package zio.aws.backupstorage.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PutChunkResponse(
    chunkChecksum: String,
    chunkChecksumAlgorithm: zio.aws.backupstorage.model.DataChecksumAlgorithm
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupstorage.model.PutChunkResponse = {
    import PutChunkResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupstorage.model.PutChunkResponse
      .builder()
      .chunkChecksum(chunkChecksum: java.lang.String)
      .chunkChecksumAlgorithm(chunkChecksumAlgorithm.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.backupstorage.model.PutChunkResponse.ReadOnly =
    zio.aws.backupstorage.model.PutChunkResponse.wrap(buildAwsValue())
}
object PutChunkResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupstorage.model.PutChunkResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backupstorage.model.PutChunkResponse =
      zio.aws.backupstorage.model
        .PutChunkResponse(chunkChecksum, chunkChecksumAlgorithm)
    def chunkChecksum: String
    def chunkChecksumAlgorithm
        : zio.aws.backupstorage.model.DataChecksumAlgorithm
    def getChunkChecksum: ZIO[Any, Nothing, String] = ZIO.succeed(chunkChecksum)
    def getChunkChecksumAlgorithm
        : ZIO[Any, Nothing, zio.aws.backupstorage.model.DataChecksumAlgorithm] =
      ZIO.succeed(chunkChecksumAlgorithm)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupstorage.model.PutChunkResponse
  ) extends zio.aws.backupstorage.model.PutChunkResponse.ReadOnly {
    override val chunkChecksum: String = impl.chunkChecksum(): String
    override val chunkChecksumAlgorithm
        : zio.aws.backupstorage.model.DataChecksumAlgorithm =
      zio.aws.backupstorage.model.DataChecksumAlgorithm
        .wrap(impl.chunkChecksumAlgorithm())
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupstorage.model.PutChunkResponse
  ): zio.aws.backupstorage.model.PutChunkResponse.ReadOnly = new Wrapper(impl)
}
