package zio.aws.backupstorage.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetChunkResponse(
    length: Long,
    checksum: String,
    checksumAlgorithm: zio.aws.backupstorage.model.DataChecksumAlgorithm
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupstorage.model.GetChunkResponse = {
    import GetChunkResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupstorage.model.GetChunkResponse
      .builder()
      .length(length: java.lang.Long)
      .checksum(checksum: java.lang.String)
      .checksumAlgorithm(checksumAlgorithm.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.backupstorage.model.GetChunkResponse.ReadOnly =
    zio.aws.backupstorage.model.GetChunkResponse.wrap(buildAwsValue())
}
object GetChunkResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupstorage.model.GetChunkResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backupstorage.model.GetChunkResponse =
      zio.aws.backupstorage.model
        .GetChunkResponse(length, checksum, checksumAlgorithm)
    def length: Long
    def checksum: String
    def checksumAlgorithm: zio.aws.backupstorage.model.DataChecksumAlgorithm
    def getLength: ZIO[Any, Nothing, Long] = ZIO.succeed(length)
    def getChecksum: ZIO[Any, Nothing, String] = ZIO.succeed(checksum)
    def getChecksumAlgorithm
        : ZIO[Any, Nothing, zio.aws.backupstorage.model.DataChecksumAlgorithm] =
      ZIO.succeed(checksumAlgorithm)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupstorage.model.GetChunkResponse
  ) extends zio.aws.backupstorage.model.GetChunkResponse.ReadOnly {
    override val length: Long = impl.length(): Long
    override val checksum: String = impl.checksum(): String
    override val checksumAlgorithm
        : zio.aws.backupstorage.model.DataChecksumAlgorithm =
      zio.aws.backupstorage.model.DataChecksumAlgorithm
        .wrap(impl.checksumAlgorithm())
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupstorage.model.GetChunkResponse
  ): zio.aws.backupstorage.model.GetChunkResponse.ReadOnly = new Wrapper(impl)
}
