package zio.aws.backupstorage
import zio.aws.backupstorage.model.PutChunkResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import software.amazon.awssdk.services.backupstorage.model.{
  ListChunksResponse,
  ListObjectsRequest,
  StartObjectRequest,
  PutChunkResponse,
  NotifyObjectCompleteRequest,
  ListChunksRequest,
  DeleteObjectResponse,
  PutObjectRequest,
  PutChunkRequest,
  BackupObject,
  GetChunkRequest,
  ListObjectsResponse,
  PutObjectResponse,
  GetChunkResponse,
  GetObjectMetadataResponse,
  NotifyObjectCompleteResponse,
  GetObjectMetadataRequest,
  DeleteObjectRequest,
  StartObjectResponse,
  Chunk
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, Task, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.backupstorage.{
  BackupStorageAsyncClientBuilder,
  BackupStorageAsyncClient
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait BackupStorage extends AspectSupport[BackupStorage] {
  val api: BackupStorageAsyncClient
  def listChunks(
      request: zio.aws.backupstorage.model.ListChunksRequest
  ): ZStream[Any, AwsError, zio.aws.backupstorage.model.Chunk.ReadOnly]
  def listChunksPaginated(
      request: zio.aws.backupstorage.model.ListChunksRequest
  ): IO[AwsError, zio.aws.backupstorage.model.ListChunksResponse.ReadOnly]
  def getChunk(
      request: zio.aws.backupstorage.model.GetChunkRequest
  ): IO[AwsError, StreamingOutputResult[
    Any,
    zio.aws.backupstorage.model.GetChunkResponse.ReadOnly,
    Byte
  ]]
  def getObjectMetadata(
      request: zio.aws.backupstorage.model.GetObjectMetadataRequest
  ): IO[AwsError, StreamingOutputResult[
    Any,
    zio.aws.backupstorage.model.GetObjectMetadataResponse.ReadOnly,
    Byte
  ]]
  def deleteObject(
      request: zio.aws.backupstorage.model.DeleteObjectRequest
  ): IO[AwsError, Unit]
  def putChunk(
      request: zio.aws.backupstorage.model.PutChunkRequest,
      body: ZStream[Any, AwsError, Byte]
  ): IO[AwsError, ReadOnly]
  def listObjects(
      request: zio.aws.backupstorage.model.ListObjectsRequest
  ): ZStream[Any, AwsError, zio.aws.backupstorage.model.BackupObject.ReadOnly]
  def listObjectsPaginated(
      request: zio.aws.backupstorage.model.ListObjectsRequest
  ): IO[AwsError, zio.aws.backupstorage.model.ListObjectsResponse.ReadOnly]
  def putObject(
      request: zio.aws.backupstorage.model.PutObjectRequest,
      body: ZStream[Any, AwsError, Byte]
  ): IO[AwsError, zio.aws.backupstorage.model.PutObjectResponse.ReadOnly]
  def startObject(
      request: zio.aws.backupstorage.model.StartObjectRequest
  ): IO[AwsError, zio.aws.backupstorage.model.StartObjectResponse.ReadOnly]
  def notifyObjectComplete(
      request: zio.aws.backupstorage.model.NotifyObjectCompleteRequest,
      body: ZStream[Any, AwsError, Byte]
  ): IO[
    AwsError,
    zio.aws.backupstorage.model.NotifyObjectCompleteResponse.ReadOnly
  ]
}
object BackupStorage {
  val live: ZLayer[AwsConfig, java.lang.Throwable, BackupStorage] = customized(
    identity
  )
  def customized(
      customization: BackupStorageAsyncClientBuilder => BackupStorageAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, BackupStorage] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: BackupStorageAsyncClientBuilder => BackupStorageAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, BackupStorage] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = BackupStorageAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[BackupStorageAsyncClient, BackupStorageAsyncClientBuilder](
        builder
      );
    b1 <- awsConfig.configureHttpClient[
      BackupStorageAsyncClient,
      BackupStorageAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new BackupStorageImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class BackupStorageImpl[R](
      override val api: BackupStorageAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends BackupStorage
      with AwsServiceBase[R] {
    override val serviceName: String = "BackupStorage"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): BackupStorageImpl[R1] = new BackupStorageImpl(api, newAspect, r)
    def listChunks(
        request: zio.aws.backupstorage.model.ListChunksRequest
    ): ZStream[Any, AwsError, zio.aws.backupstorage.model.Chunk.ReadOnly] =
      asyncSimplePaginatedRequest[ListChunksRequest, ListChunksResponse, Chunk](
        "listChunks",
        api.listChunks,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.chunkList().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.backupstorage.model.Chunk.wrap(item))
        .provideEnvironment(r)
    def listChunksPaginated(
        request: zio.aws.backupstorage.model.ListChunksRequest
    ): IO[AwsError, zio.aws.backupstorage.model.ListChunksResponse.ReadOnly] =
      asyncRequestResponse[ListChunksRequest, ListChunksResponse](
        "listChunks",
        api.listChunks
      )(request.buildAwsValue())
        .map(zio.aws.backupstorage.model.ListChunksResponse.wrap)
        .provideEnvironment(r)
    def getChunk(
        request: zio.aws.backupstorage.model.GetChunkRequest
    ): IO[AwsError, StreamingOutputResult[
      Any,
      zio.aws.backupstorage.model.GetChunkResponse.ReadOnly,
      Byte
    ]] = asyncRequestOutputStream[GetChunkRequest, GetChunkResponse](
      "getChunk",
      api.getChunk[Task[StreamingOutputResult[R, GetChunkResponse, Byte]]]
    )(request.buildAwsValue())
      .map(
        _.mapResponse(zio.aws.backupstorage.model.GetChunkResponse.wrap)
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def getObjectMetadata(
        request: zio.aws.backupstorage.model.GetObjectMetadataRequest
    ): IO[AwsError, StreamingOutputResult[
      Any,
      zio.aws.backupstorage.model.GetObjectMetadataResponse.ReadOnly,
      Byte
    ]] = asyncRequestOutputStream[
      GetObjectMetadataRequest,
      GetObjectMetadataResponse
    ](
      "getObjectMetadata",
      api.getObjectMetadata[Task[
        StreamingOutputResult[R, GetObjectMetadataResponse, Byte]
      ]]
    )(request.buildAwsValue())
      .map(
        _.mapResponse(
          zio.aws.backupstorage.model.GetObjectMetadataResponse.wrap
        ).provideEnvironment(r)
      )
      .provideEnvironment(r)
    def deleteObject(
        request: zio.aws.backupstorage.model.DeleteObjectRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteObjectRequest, DeleteObjectResponse](
        "deleteObject",
        api.deleteObject
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def putChunk(
        request: zio.aws.backupstorage.model.PutChunkRequest,
        body: ZStream[Any, AwsError, Byte]
    ): IO[AwsError, ReadOnly] =
      asyncRequestInputStream[PutChunkRequest, PutChunkResponse](
        "putChunk",
        api.putChunk,
        AwsServiceBase.noContentLength[PutChunkRequest]
      )(request.buildAwsValue(), body)
        .map(zio.aws.backupstorage.model.PutChunkResponse.wrap)
        .provideEnvironment(r)
    def listObjects(
        request: zio.aws.backupstorage.model.ListObjectsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.backupstorage.model.BackupObject.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListObjectsRequest,
      ListObjectsResponse,
      BackupObject
    ](
      "listObjects",
      api.listObjects,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.objectList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.backupstorage.model.BackupObject.wrap(item))
      .provideEnvironment(r)
    def listObjectsPaginated(
        request: zio.aws.backupstorage.model.ListObjectsRequest
    ): IO[AwsError, zio.aws.backupstorage.model.ListObjectsResponse.ReadOnly] =
      asyncRequestResponse[ListObjectsRequest, ListObjectsResponse](
        "listObjects",
        api.listObjects
      )(request.buildAwsValue())
        .map(zio.aws.backupstorage.model.ListObjectsResponse.wrap)
        .provideEnvironment(r)
    def putObject(
        request: zio.aws.backupstorage.model.PutObjectRequest,
        body: ZStream[Any, AwsError, Byte]
    ): IO[AwsError, zio.aws.backupstorage.model.PutObjectResponse.ReadOnly] =
      asyncRequestInputStream[PutObjectRequest, PutObjectResponse](
        "putObject",
        api.putObject,
        AwsServiceBase.noContentLength[PutObjectRequest]
      )(request.buildAwsValue(), body)
        .map(zio.aws.backupstorage.model.PutObjectResponse.wrap)
        .provideEnvironment(r)
    def startObject(
        request: zio.aws.backupstorage.model.StartObjectRequest
    ): IO[AwsError, zio.aws.backupstorage.model.StartObjectResponse.ReadOnly] =
      asyncRequestResponse[StartObjectRequest, StartObjectResponse](
        "startObject",
        api.startObject
      )(request.buildAwsValue())
        .map(zio.aws.backupstorage.model.StartObjectResponse.wrap)
        .provideEnvironment(r)
    def notifyObjectComplete(
        request: zio.aws.backupstorage.model.NotifyObjectCompleteRequest,
        body: ZStream[Any, AwsError, Byte]
    ): IO[
      AwsError,
      zio.aws.backupstorage.model.NotifyObjectCompleteResponse.ReadOnly
    ] = asyncRequestInputStream[
      NotifyObjectCompleteRequest,
      NotifyObjectCompleteResponse
    ](
      "notifyObjectComplete",
      api.notifyObjectComplete,
      AwsServiceBase.noContentLength[NotifyObjectCompleteRequest]
    )(request.buildAwsValue(), body)
      .map(zio.aws.backupstorage.model.NotifyObjectCompleteResponse.wrap)
      .provideEnvironment(r)
  }
  def listChunks(
      request: zio.aws.backupstorage.model.ListChunksRequest
  ): ZStream[
    zio.aws.backupstorage.BackupStorage,
    AwsError,
    zio.aws.backupstorage.model.Chunk.ReadOnly
  ] = ZStream.serviceWithStream(_.listChunks(request))
  def listChunksPaginated(
      request: zio.aws.backupstorage.model.ListChunksRequest
  ): ZIO[
    zio.aws.backupstorage.BackupStorage,
    AwsError,
    zio.aws.backupstorage.model.ListChunksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listChunksPaginated(request))
  def getChunk(
      request: zio.aws.backupstorage.model.GetChunkRequest
  ): ZIO[zio.aws.backupstorage.BackupStorage, AwsError, StreamingOutputResult[
    Any,
    zio.aws.backupstorage.model.GetChunkResponse.ReadOnly,
    Byte
  ]] = ZIO.serviceWithZIO(_.getChunk(request))
  def getObjectMetadata(
      request: zio.aws.backupstorage.model.GetObjectMetadataRequest
  ): ZIO[zio.aws.backupstorage.BackupStorage, AwsError, StreamingOutputResult[
    Any,
    zio.aws.backupstorage.model.GetObjectMetadataResponse.ReadOnly,
    Byte
  ]] = ZIO.serviceWithZIO(_.getObjectMetadata(request))
  def deleteObject(
      request: zio.aws.backupstorage.model.DeleteObjectRequest
  ): ZIO[zio.aws.backupstorage.BackupStorage, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteObject(request))
  def putChunk(
      request: zio.aws.backupstorage.model.PutChunkRequest,
      body: ZStream[Any, AwsError, Byte]
  ): ZIO[zio.aws.backupstorage.BackupStorage, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.putChunk(request, body))
  def listObjects(
      request: zio.aws.backupstorage.model.ListObjectsRequest
  ): ZStream[
    zio.aws.backupstorage.BackupStorage,
    AwsError,
    zio.aws.backupstorage.model.BackupObject.ReadOnly
  ] = ZStream.serviceWithStream(_.listObjects(request))
  def listObjectsPaginated(
      request: zio.aws.backupstorage.model.ListObjectsRequest
  ): ZIO[
    zio.aws.backupstorage.BackupStorage,
    AwsError,
    zio.aws.backupstorage.model.ListObjectsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listObjectsPaginated(request))
  def putObject(
      request: zio.aws.backupstorage.model.PutObjectRequest,
      body: ZStream[Any, AwsError, Byte]
  ): ZIO[
    zio.aws.backupstorage.BackupStorage,
    AwsError,
    zio.aws.backupstorage.model.PutObjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putObject(request, body))
  def startObject(request: zio.aws.backupstorage.model.StartObjectRequest): ZIO[
    zio.aws.backupstorage.BackupStorage,
    AwsError,
    zio.aws.backupstorage.model.StartObjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startObject(request))
  def notifyObjectComplete(
      request: zio.aws.backupstorage.model.NotifyObjectCompleteRequest,
      body: ZStream[Any, AwsError, Byte]
  ): ZIO[
    zio.aws.backupstorage.BackupStorage,
    AwsError,
    zio.aws.backupstorage.model.NotifyObjectCompleteResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.notifyObjectComplete(request, body))
}
