package zio.aws.backupstorage.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListObjectsResponse(
    objectList: Iterable[zio.aws.backupstorage.model.BackupObject],
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupstorage.model.ListObjectsResponse = {
    import ListObjectsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupstorage.model.ListObjectsResponse
      .builder()
      .objectList(objectList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.backupstorage.model.ListObjectsResponse.ReadOnly =
    zio.aws.backupstorage.model.ListObjectsResponse.wrap(buildAwsValue())
}
object ListObjectsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupstorage.model.ListObjectsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backupstorage.model.ListObjectsResponse =
      zio.aws.backupstorage.model.ListObjectsResponse(
        objectList.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def objectList: List[zio.aws.backupstorage.model.BackupObject.ReadOnly]
    def nextToken: Optional[String]
    def getObjectList: ZIO[Any, Nothing, List[
      zio.aws.backupstorage.model.BackupObject.ReadOnly
    ]] = ZIO.succeed(objectList)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupstorage.model.ListObjectsResponse
  ) extends zio.aws.backupstorage.model.ListObjectsResponse.ReadOnly {
    override val objectList
        : List[zio.aws.backupstorage.model.BackupObject.ReadOnly] = impl
      .objectList()
      .asScala
      .map { item =>
        zio.aws.backupstorage.model.BackupObject.wrap(item)
      }
      .toList
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupstorage.model.ListObjectsResponse
  ): zio.aws.backupstorage.model.ListObjectsResponse.ReadOnly = new Wrapper(
    impl
  )
}
