package zio.aws.backupstorage.model
import scala.jdk.CollectionConverters._
sealed trait SummaryChecksumAlgorithm {
  def unwrap: software.amazon.awssdk.services.backupstorage.model.SummaryChecksumAlgorithm
}
object SummaryChecksumAlgorithm {
  def wrap(
      value: software.amazon.awssdk.services.backupstorage.model.SummaryChecksumAlgorithm
  ): zio.aws.backupstorage.model.SummaryChecksumAlgorithm = value match {
    case software.amazon.awssdk.services.backupstorage.model.SummaryChecksumAlgorithm.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.backupstorage.model.SummaryChecksumAlgorithm.SUMMARY =>
      val r = SUMMARY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.backupstorage.model.SummaryChecksumAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.backupstorage.model.SummaryChecksumAlgorithm =
      software.amazon.awssdk.services.backupstorage.model.SummaryChecksumAlgorithm.UNKNOWN_TO_SDK_VERSION
  }
  case object SUMMARY
      extends zio.aws.backupstorage.model.SummaryChecksumAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.backupstorage.model.SummaryChecksumAlgorithm =
      software.amazon.awssdk.services.backupstorage.model.SummaryChecksumAlgorithm.SUMMARY
  }
}
