package zio.aws.backupgateway.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.backupgateway.model.primitives.{
  VmwareTagName,
  VmwareCategory,
  TagValue,
  TagKey
}
import scala.jdk.CollectionConverters.*
final case class VmwareToAwsTagMapping(
    awsTagKey: TagKey,
    awsTagValue: TagValue,
    vmwareCategory: VmwareCategory,
    vmwareTagName: VmwareTagName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupgateway.model.VmwareToAwsTagMapping = {
    import VmwareToAwsTagMapping.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupgateway.model.VmwareToAwsTagMapping
      .builder()
      .awsTagKey(TagKey.unwrap(awsTagKey): java.lang.String)
      .awsTagValue(TagValue.unwrap(awsTagValue): java.lang.String)
      .vmwareCategory(VmwareCategory.unwrap(vmwareCategory): java.lang.String)
      .vmwareTagName(VmwareTagName.unwrap(vmwareTagName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.backupgateway.model.VmwareToAwsTagMapping.ReadOnly =
    zio.aws.backupgateway.model.VmwareToAwsTagMapping.wrap(buildAwsValue())
}
object VmwareToAwsTagMapping {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupgateway.model.VmwareToAwsTagMapping
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backupgateway.model.VmwareToAwsTagMapping =
      zio.aws.backupgateway.model.VmwareToAwsTagMapping(
        awsTagKey,
        awsTagValue,
        vmwareCategory,
        vmwareTagName
      )
    def awsTagKey: TagKey
    def awsTagValue: TagValue
    def vmwareCategory: VmwareCategory
    def vmwareTagName: VmwareTagName
    def getAwsTagKey: ZIO[Any, Nothing, TagKey] = ZIO.succeed(awsTagKey)
    def getAwsTagValue: ZIO[Any, Nothing, TagValue] = ZIO.succeed(awsTagValue)
    def getVmwareCategory: ZIO[Any, Nothing, VmwareCategory] =
      ZIO.succeed(vmwareCategory)
    def getVmwareTagName: ZIO[Any, Nothing, VmwareTagName] =
      ZIO.succeed(vmwareTagName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupgateway.model.VmwareToAwsTagMapping
  ) extends zio.aws.backupgateway.model.VmwareToAwsTagMapping.ReadOnly {
    override val awsTagKey: TagKey =
      zio.aws.backupgateway.model.primitives.TagKey(impl.awsTagKey())
    override val awsTagValue: TagValue =
      zio.aws.backupgateway.model.primitives.TagValue(impl.awsTagValue())
    override val vmwareCategory: VmwareCategory =
      zio.aws.backupgateway.model.primitives
        .VmwareCategory(impl.vmwareCategory())
    override val vmwareTagName: VmwareTagName =
      zio.aws.backupgateway.model.primitives.VmwareTagName(impl.vmwareTagName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupgateway.model.VmwareToAwsTagMapping
  ): zio.aws.backupgateway.model.VmwareToAwsTagMapping.ReadOnly = new Wrapper(
    impl
  )
}
