package zio.aws.backupgateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.backupgateway.model.primitives.GatewayArn
import scala.jdk.CollectionConverters.*
final case class UpdateGatewaySoftwareNowResponse(
    gatewayArn: Optional[GatewayArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupgateway.model.UpdateGatewaySoftwareNowResponse = {
    import UpdateGatewaySoftwareNowResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupgateway.model.UpdateGatewaySoftwareNowResponse
      .builder()
      .optionallyWith(
        gatewayArn.map(value => GatewayArn.unwrap(value): java.lang.String)
      )(_.gatewayArn)
      .build()
  }
  def asReadOnly
      : zio.aws.backupgateway.model.UpdateGatewaySoftwareNowResponse.ReadOnly =
    zio.aws.backupgateway.model.UpdateGatewaySoftwareNowResponse
      .wrap(buildAwsValue())
}
object UpdateGatewaySoftwareNowResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupgateway.model.UpdateGatewaySoftwareNowResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.backupgateway.model.UpdateGatewaySoftwareNowResponse =
      zio.aws.backupgateway.model
        .UpdateGatewaySoftwareNowResponse(gatewayArn.map(value => value))
    def gatewayArn: Optional[GatewayArn]
    def getGatewayArn: ZIO[Any, AwsError, GatewayArn] =
      AwsError.unwrapOptionField("gatewayArn", gatewayArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupgateway.model.UpdateGatewaySoftwareNowResponse
  ) extends zio.aws.backupgateway.model.UpdateGatewaySoftwareNowResponse.ReadOnly {
    override val gatewayArn: Optional[GatewayArn] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayArn())
      .map(value => zio.aws.backupgateway.model.primitives.GatewayArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupgateway.model.UpdateGatewaySoftwareNowResponse
  ): zio.aws.backupgateway.model.UpdateGatewaySoftwareNowResponse.ReadOnly =
    new Wrapper(impl)
}
