package zio.aws.backupgateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.backupgateway.model.primitives.ServerArn
import scala.jdk.CollectionConverters.*
final case class StartVirtualMachinesMetadataSyncResponse(
    hypervisorArn: Optional[ServerArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupgateway.model.StartVirtualMachinesMetadataSyncResponse = {
    import StartVirtualMachinesMetadataSyncResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupgateway.model.StartVirtualMachinesMetadataSyncResponse
      .builder()
      .optionallyWith(
        hypervisorArn.map(value => ServerArn.unwrap(value): java.lang.String)
      )(_.hypervisorArn)
      .build()
  }
  def asReadOnly
      : zio.aws.backupgateway.model.StartVirtualMachinesMetadataSyncResponse.ReadOnly =
    zio.aws.backupgateway.model.StartVirtualMachinesMetadataSyncResponse
      .wrap(buildAwsValue())
}
object StartVirtualMachinesMetadataSyncResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupgateway.model.StartVirtualMachinesMetadataSyncResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.backupgateway.model.StartVirtualMachinesMetadataSyncResponse =
      zio.aws.backupgateway.model.StartVirtualMachinesMetadataSyncResponse(
        hypervisorArn.map(value => value)
      )
    def hypervisorArn: Optional[ServerArn]
    def getHypervisorArn: ZIO[Any, AwsError, ServerArn] =
      AwsError.unwrapOptionField("hypervisorArn", hypervisorArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupgateway.model.StartVirtualMachinesMetadataSyncResponse
  ) extends zio.aws.backupgateway.model.StartVirtualMachinesMetadataSyncResponse.ReadOnly {
    override val hypervisorArn: Optional[ServerArn] = zio.aws.core.internal
      .optionalFromNullable(impl.hypervisorArn())
      .map(value => zio.aws.backupgateway.model.primitives.ServerArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupgateway.model.StartVirtualMachinesMetadataSyncResponse
  ): zio.aws.backupgateway.model.StartVirtualMachinesMetadataSyncResponse.ReadOnly =
    new Wrapper(impl)
}
