package zio.aws.backupgateway.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.backupgateway.model.primitives.ServerArn
import scala.jdk.CollectionConverters.*
final case class StartVirtualMachinesMetadataSyncRequest(
    hypervisorArn: ServerArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupgateway.model.StartVirtualMachinesMetadataSyncRequest = {
    import StartVirtualMachinesMetadataSyncRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupgateway.model.StartVirtualMachinesMetadataSyncRequest
      .builder()
      .hypervisorArn(ServerArn.unwrap(hypervisorArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.backupgateway.model.StartVirtualMachinesMetadataSyncRequest.ReadOnly =
    zio.aws.backupgateway.model.StartVirtualMachinesMetadataSyncRequest
      .wrap(buildAwsValue())
}
object StartVirtualMachinesMetadataSyncRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupgateway.model.StartVirtualMachinesMetadataSyncRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.backupgateway.model.StartVirtualMachinesMetadataSyncRequest =
      zio.aws.backupgateway.model
        .StartVirtualMachinesMetadataSyncRequest(hypervisorArn)
    def hypervisorArn: ServerArn
    def getHypervisorArn: ZIO[Any, Nothing, ServerArn] =
      ZIO.succeed(hypervisorArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupgateway.model.StartVirtualMachinesMetadataSyncRequest
  ) extends zio.aws.backupgateway.model.StartVirtualMachinesMetadataSyncRequest.ReadOnly {
    override val hypervisorArn: ServerArn =
      zio.aws.backupgateway.model.primitives.ServerArn(impl.hypervisorArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupgateway.model.StartVirtualMachinesMetadataSyncRequest
  ): zio.aws.backupgateway.model.StartVirtualMachinesMetadataSyncRequest.ReadOnly =
    new Wrapper(impl)
}
