package zio.aws.backupgateway.model
import scala.jdk.CollectionConverters.*
sealed trait GatewayType {
  def unwrap: software.amazon.awssdk.services.backupgateway.model.GatewayType
}
object GatewayType {
  def wrap(
      value: software.amazon.awssdk.services.backupgateway.model.GatewayType
  ): zio.aws.backupgateway.model.GatewayType = value match {
    case software.amazon.awssdk.services.backupgateway.model.GatewayType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.backupgateway.model.GatewayType.BACKUP_VM =>
      val r = BACKUP_VM
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.backupgateway.model.GatewayType {
    override def unwrap
        : software.amazon.awssdk.services.backupgateway.model.GatewayType =
      software.amazon.awssdk.services.backupgateway.model.GatewayType.UNKNOWN_TO_SDK_VERSION
  }
  case object BACKUP_VM extends zio.aws.backupgateway.model.GatewayType {
    override def unwrap
        : software.amazon.awssdk.services.backupgateway.model.GatewayType =
      software.amazon.awssdk.services.backupgateway.model.GatewayType.BACKUP_VM
  }
}
