package zio.aws.backupgateway.model
import zio.aws.backupgateway.model.primitives.{
  Time,
  GatewayArn,
  VpcEndpoint,
  Name,
  HypervisorId
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class GatewayDetails(
    gatewayArn: Optional[GatewayArn] = Optional.Absent,
    gatewayDisplayName: Optional[Name] = Optional.Absent,
    gatewayType: Optional[zio.aws.backupgateway.model.GatewayType] =
      Optional.Absent,
    hypervisorId: Optional[HypervisorId] = Optional.Absent,
    lastSeenTime: Optional[Time] = Optional.Absent,
    maintenanceStartTime: Optional[
      zio.aws.backupgateway.model.MaintenanceStartTime
    ] = Optional.Absent,
    nextUpdateAvailabilityTime: Optional[Time] = Optional.Absent,
    vpcEndpoint: Optional[VpcEndpoint] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupgateway.model.GatewayDetails = {
    import GatewayDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupgateway.model.GatewayDetails
      .builder()
      .optionallyWith(
        gatewayArn.map(value => GatewayArn.unwrap(value): java.lang.String)
      )(_.gatewayArn)
      .optionallyWith(
        gatewayDisplayName.map(value => Name.unwrap(value): java.lang.String)
      )(_.gatewayDisplayName)
      .optionallyWith(gatewayType.map(value => value.unwrap))(_.gatewayType)
      .optionallyWith(
        hypervisorId.map(value => HypervisorId.unwrap(value): java.lang.String)
      )(_.hypervisorId)
      .optionallyWith(lastSeenTime.map(value => Time.unwrap(value): Instant))(
        _.lastSeenTime
      )
      .optionallyWith(maintenanceStartTime.map(value => value.buildAwsValue()))(
        _.maintenanceStartTime
      )
      .optionallyWith(
        nextUpdateAvailabilityTime.map(value => Time.unwrap(value): Instant)
      )(_.nextUpdateAvailabilityTime)
      .optionallyWith(
        vpcEndpoint.map(value => VpcEndpoint.unwrap(value): java.lang.String)
      )(_.vpcEndpoint)
      .build()
  }
  def asReadOnly: zio.aws.backupgateway.model.GatewayDetails.ReadOnly =
    zio.aws.backupgateway.model.GatewayDetails.wrap(buildAwsValue())
}
object GatewayDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupgateway.model.GatewayDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backupgateway.model.GatewayDetails =
      zio.aws.backupgateway.model.GatewayDetails(
        gatewayArn.map(value => value),
        gatewayDisplayName.map(value => value),
        gatewayType.map(value => value),
        hypervisorId.map(value => value),
        lastSeenTime.map(value => value),
        maintenanceStartTime.map(value => value.asEditable),
        nextUpdateAvailabilityTime.map(value => value),
        vpcEndpoint.map(value => value)
      )
    def gatewayArn: Optional[GatewayArn]
    def gatewayDisplayName: Optional[Name]
    def gatewayType: Optional[zio.aws.backupgateway.model.GatewayType]
    def hypervisorId: Optional[HypervisorId]
    def lastSeenTime: Optional[Time]
    def maintenanceStartTime
        : Optional[zio.aws.backupgateway.model.MaintenanceStartTime.ReadOnly]
    def nextUpdateAvailabilityTime: Optional[Time]
    def vpcEndpoint: Optional[VpcEndpoint]
    def getGatewayArn: ZIO[Any, AwsError, GatewayArn] =
      AwsError.unwrapOptionField("gatewayArn", gatewayArn)
    def getGatewayDisplayName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("gatewayDisplayName", gatewayDisplayName)
    def getGatewayType
        : ZIO[Any, AwsError, zio.aws.backupgateway.model.GatewayType] =
      AwsError.unwrapOptionField("gatewayType", gatewayType)
    def getHypervisorId: ZIO[Any, AwsError, HypervisorId] =
      AwsError.unwrapOptionField("hypervisorId", hypervisorId)
    def getLastSeenTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("lastSeenTime", lastSeenTime)
    def getMaintenanceStartTime: ZIO[
      Any,
      AwsError,
      zio.aws.backupgateway.model.MaintenanceStartTime.ReadOnly
    ] = AwsError.unwrapOptionField("maintenanceStartTime", maintenanceStartTime)
    def getNextUpdateAvailabilityTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField(
        "nextUpdateAvailabilityTime",
        nextUpdateAvailabilityTime
      )
    def getVpcEndpoint: ZIO[Any, AwsError, VpcEndpoint] =
      AwsError.unwrapOptionField("vpcEndpoint", vpcEndpoint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupgateway.model.GatewayDetails
  ) extends zio.aws.backupgateway.model.GatewayDetails.ReadOnly {
    override val gatewayArn: Optional[GatewayArn] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayArn())
      .map(value => zio.aws.backupgateway.model.primitives.GatewayArn(value))
    override val gatewayDisplayName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayDisplayName())
      .map(value => zio.aws.backupgateway.model.primitives.Name(value))
    override val gatewayType
        : Optional[zio.aws.backupgateway.model.GatewayType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gatewayType())
        .map(value => zio.aws.backupgateway.model.GatewayType.wrap(value))
    override val hypervisorId: Optional[HypervisorId] = zio.aws.core.internal
      .optionalFromNullable(impl.hypervisorId())
      .map(value => zio.aws.backupgateway.model.primitives.HypervisorId(value))
    override val lastSeenTime: Optional[Time] = zio.aws.core.internal
      .optionalFromNullable(impl.lastSeenTime())
      .map(value => zio.aws.backupgateway.model.primitives.Time(value))
    override val maintenanceStartTime
        : Optional[zio.aws.backupgateway.model.MaintenanceStartTime.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maintenanceStartTime())
        .map(value =>
          zio.aws.backupgateway.model.MaintenanceStartTime.wrap(value)
        )
    override val nextUpdateAvailabilityTime: Optional[Time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextUpdateAvailabilityTime())
        .map(value => zio.aws.backupgateway.model.primitives.Time(value))
    override val vpcEndpoint: Optional[VpcEndpoint] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcEndpoint())
      .map(value => zio.aws.backupgateway.model.primitives.VpcEndpoint(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupgateway.model.GatewayDetails
  ): zio.aws.backupgateway.model.GatewayDetails.ReadOnly = new Wrapper(impl)
}
