package zio.aws.backupgateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.backupgateway.model.primitives.{Name, ActivationKey}
import scala.jdk.CollectionConverters.*
final case class CreateGatewayRequest(
    activationKey: ActivationKey,
    gatewayDisplayName: Name,
    gatewayType: zio.aws.backupgateway.model.GatewayType,
    tags: Optional[Iterable[zio.aws.backupgateway.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupgateway.model.CreateGatewayRequest = {
    import CreateGatewayRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupgateway.model.CreateGatewayRequest
      .builder()
      .activationKey(ActivationKey.unwrap(activationKey): java.lang.String)
      .gatewayDisplayName(Name.unwrap(gatewayDisplayName): java.lang.String)
      .gatewayType(gatewayType.unwrap)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.backupgateway.model.CreateGatewayRequest.ReadOnly =
    zio.aws.backupgateway.model.CreateGatewayRequest.wrap(buildAwsValue())
}
object CreateGatewayRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupgateway.model.CreateGatewayRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backupgateway.model.CreateGatewayRequest =
      zio.aws.backupgateway.model.CreateGatewayRequest(
        activationKey,
        gatewayDisplayName,
        gatewayType,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def activationKey: ActivationKey
    def gatewayDisplayName: Name
    def gatewayType: zio.aws.backupgateway.model.GatewayType
    def tags: Optional[List[zio.aws.backupgateway.model.Tag.ReadOnly]]
    def getActivationKey: ZIO[Any, Nothing, ActivationKey] =
      ZIO.succeed(activationKey)
    def getGatewayDisplayName: ZIO[Any, Nothing, Name] =
      ZIO.succeed(gatewayDisplayName)
    def getGatewayType
        : ZIO[Any, Nothing, zio.aws.backupgateway.model.GatewayType] =
      ZIO.succeed(gatewayType)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.backupgateway.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupgateway.model.CreateGatewayRequest
  ) extends zio.aws.backupgateway.model.CreateGatewayRequest.ReadOnly {
    override val activationKey: ActivationKey =
      zio.aws.backupgateway.model.primitives.ActivationKey(impl.activationKey())
    override val gatewayDisplayName: Name =
      zio.aws.backupgateway.model.primitives.Name(impl.gatewayDisplayName())
    override val gatewayType: zio.aws.backupgateway.model.GatewayType =
      zio.aws.backupgateway.model.GatewayType.wrap(impl.gatewayType())
    override val tags
        : Optional[List[zio.aws.backupgateway.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.backupgateway.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupgateway.model.CreateGatewayRequest
  ): zio.aws.backupgateway.model.CreateGatewayRequest.ReadOnly = new Wrapper(
    impl
  )
}
