package zio.aws.backupgateway.model
import zio.aws.backupgateway.model.primitives.{
  MinuteOfHour,
  HourOfDay,
  DayOfWeek,
  AverageUploadRateLimit
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class BandwidthRateLimitInterval(
    averageUploadRateLimitInBitsPerSec: Optional[AverageUploadRateLimit] =
      Optional.Absent,
    daysOfWeek: Iterable[DayOfWeek],
    endHourOfDay: HourOfDay,
    endMinuteOfHour: MinuteOfHour,
    startHourOfDay: HourOfDay,
    startMinuteOfHour: MinuteOfHour
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupgateway.model.BandwidthRateLimitInterval = {
    import BandwidthRateLimitInterval.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupgateway.model.BandwidthRateLimitInterval
      .builder()
      .optionallyWith(
        averageUploadRateLimitInBitsPerSec.map(value =>
          AverageUploadRateLimit.unwrap(value): java.lang.Long
        )
      )(_.averageUploadRateLimitInBitsPerSec)
      .daysOfWeek(daysOfWeek.map { item =>
        DayOfWeek.unwrap(item): Integer
      }.asJavaCollection)
      .endHourOfDay(HourOfDay.unwrap(endHourOfDay): Integer)
      .endMinuteOfHour(MinuteOfHour.unwrap(endMinuteOfHour): Integer)
      .startHourOfDay(HourOfDay.unwrap(startHourOfDay): Integer)
      .startMinuteOfHour(MinuteOfHour.unwrap(startMinuteOfHour): Integer)
      .build()
  }
  def asReadOnly
      : zio.aws.backupgateway.model.BandwidthRateLimitInterval.ReadOnly =
    zio.aws.backupgateway.model.BandwidthRateLimitInterval.wrap(buildAwsValue())
}
object BandwidthRateLimitInterval {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupgateway.model.BandwidthRateLimitInterval
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backupgateway.model.BandwidthRateLimitInterval =
      zio.aws.backupgateway.model.BandwidthRateLimitInterval(
        averageUploadRateLimitInBitsPerSec.map(value => value),
        daysOfWeek,
        endHourOfDay,
        endMinuteOfHour,
        startHourOfDay,
        startMinuteOfHour
      )
    def averageUploadRateLimitInBitsPerSec: Optional[AverageUploadRateLimit]
    def daysOfWeek: List[DayOfWeek]
    def endHourOfDay: HourOfDay
    def endMinuteOfHour: MinuteOfHour
    def startHourOfDay: HourOfDay
    def startMinuteOfHour: MinuteOfHour
    def getAverageUploadRateLimitInBitsPerSec
        : ZIO[Any, AwsError, AverageUploadRateLimit] =
      AwsError.unwrapOptionField(
        "averageUploadRateLimitInBitsPerSec",
        averageUploadRateLimitInBitsPerSec
      )
    def getDaysOfWeek: ZIO[Any, Nothing, List[DayOfWeek]] =
      ZIO.succeed(daysOfWeek)
    def getEndHourOfDay: ZIO[Any, Nothing, HourOfDay] =
      ZIO.succeed(endHourOfDay)
    def getEndMinuteOfHour: ZIO[Any, Nothing, MinuteOfHour] =
      ZIO.succeed(endMinuteOfHour)
    def getStartHourOfDay: ZIO[Any, Nothing, HourOfDay] =
      ZIO.succeed(startHourOfDay)
    def getStartMinuteOfHour: ZIO[Any, Nothing, MinuteOfHour] =
      ZIO.succeed(startMinuteOfHour)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupgateway.model.BandwidthRateLimitInterval
  ) extends zio.aws.backupgateway.model.BandwidthRateLimitInterval.ReadOnly {
    override val averageUploadRateLimitInBitsPerSec
        : Optional[AverageUploadRateLimit] = zio.aws.core.internal
      .optionalFromNullable(impl.averageUploadRateLimitInBitsPerSec())
      .map(value =>
        zio.aws.backupgateway.model.primitives.AverageUploadRateLimit(value)
      )
    override val daysOfWeek: List[DayOfWeek] = impl
      .daysOfWeek()
      .asScala
      .map { item =>
        zio.aws.backupgateway.model.primitives.DayOfWeek(item)
      }
      .toList
    override val endHourOfDay: HourOfDay =
      zio.aws.backupgateway.model.primitives.HourOfDay(impl.endHourOfDay())
    override val endMinuteOfHour: MinuteOfHour =
      zio.aws.backupgateway.model.primitives
        .MinuteOfHour(impl.endMinuteOfHour())
    override val startHourOfDay: HourOfDay =
      zio.aws.backupgateway.model.primitives.HourOfDay(impl.startHourOfDay())
    override val startMinuteOfHour: MinuteOfHour =
      zio.aws.backupgateway.model.primitives
        .MinuteOfHour(impl.startMinuteOfHour())
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupgateway.model.BandwidthRateLimitInterval
  ): zio.aws.backupgateway.model.BandwidthRateLimitInterval.ReadOnly =
    new Wrapper(impl)
}
