package zio.aws.backupgateway.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.backupgateway.model.primitives.{TagKey, ResourceArn}
import scala.jdk.CollectionConverters.*
final case class UntagResourceRequest(
    resourceARN: ResourceArn,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupgateway.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupgateway.model.UntagResourceRequest
      .builder()
      .resourceARN(ResourceArn.unwrap(resourceARN): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.backupgateway.model.UntagResourceRequest.ReadOnly =
    zio.aws.backupgateway.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupgateway.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backupgateway.model.UntagResourceRequest =
      zio.aws.backupgateway.model.UntagResourceRequest(resourceARN, tagKeys)
    def resourceARN: ResourceArn
    def tagKeys: List[TagKey]
    def getResourceARN: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceARN)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupgateway.model.UntagResourceRequest
  ) extends zio.aws.backupgateway.model.UntagResourceRequest.ReadOnly {
    override val resourceARN: ResourceArn =
      zio.aws.backupgateway.model.primitives.ResourceArn(impl.resourceARN())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.backupgateway.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupgateway.model.UntagResourceRequest
  ): zio.aws.backupgateway.model.UntagResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
