package zio.aws.backupgateway.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.backupgateway.model.primitives.{IamRoleArn, ServerArn}
import scala.jdk.CollectionConverters.*
final case class PutHypervisorPropertyMappingsRequest(
    hypervisorArn: ServerArn,
    iamRoleArn: IamRoleArn,
    vmwareToAwsTagMappings: Iterable[
      zio.aws.backupgateway.model.VmwareToAwsTagMapping
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupgateway.model.PutHypervisorPropertyMappingsRequest = {
    import PutHypervisorPropertyMappingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupgateway.model.PutHypervisorPropertyMappingsRequest
      .builder()
      .hypervisorArn(ServerArn.unwrap(hypervisorArn): java.lang.String)
      .iamRoleArn(IamRoleArn.unwrap(iamRoleArn): java.lang.String)
      .vmwareToAwsTagMappings(vmwareToAwsTagMappings.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.backupgateway.model.PutHypervisorPropertyMappingsRequest.ReadOnly =
    zio.aws.backupgateway.model.PutHypervisorPropertyMappingsRequest
      .wrap(buildAwsValue())
}
object PutHypervisorPropertyMappingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupgateway.model.PutHypervisorPropertyMappingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.backupgateway.model.PutHypervisorPropertyMappingsRequest =
      zio.aws.backupgateway.model.PutHypervisorPropertyMappingsRequest(
        hypervisorArn,
        iamRoleArn,
        vmwareToAwsTagMappings.map { item =>
          item.asEditable
        }
      )
    def hypervisorArn: ServerArn
    def iamRoleArn: IamRoleArn
    def vmwareToAwsTagMappings
        : List[zio.aws.backupgateway.model.VmwareToAwsTagMapping.ReadOnly]
    def getHypervisorArn: ZIO[Any, Nothing, ServerArn] =
      ZIO.succeed(hypervisorArn)
    def getIamRoleArn: ZIO[Any, Nothing, IamRoleArn] = ZIO.succeed(iamRoleArn)
    def getVmwareToAwsTagMappings: ZIO[Any, Nothing, List[
      zio.aws.backupgateway.model.VmwareToAwsTagMapping.ReadOnly
    ]] = ZIO.succeed(vmwareToAwsTagMappings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupgateway.model.PutHypervisorPropertyMappingsRequest
  ) extends zio.aws.backupgateway.model.PutHypervisorPropertyMappingsRequest.ReadOnly {
    override val hypervisorArn: ServerArn =
      zio.aws.backupgateway.model.primitives.ServerArn(impl.hypervisorArn())
    override val iamRoleArn: IamRoleArn =
      zio.aws.backupgateway.model.primitives.IamRoleArn(impl.iamRoleArn())
    override val vmwareToAwsTagMappings
        : List[zio.aws.backupgateway.model.VmwareToAwsTagMapping.ReadOnly] =
      impl
        .vmwareToAwsTagMappings()
        .asScala
        .map { item =>
          zio.aws.backupgateway.model.VmwareToAwsTagMapping.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupgateway.model.PutHypervisorPropertyMappingsRequest
  ): zio.aws.backupgateway.model.PutHypervisorPropertyMappingsRequest.ReadOnly =
    new Wrapper(impl)
}
