package zio.aws.backupgateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.backupgateway.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListGatewaysResponse(
    gateways: Optional[Iterable[zio.aws.backupgateway.model.Gateway]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupgateway.model.ListGatewaysResponse = {
    import ListGatewaysResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupgateway.model.ListGatewaysResponse
      .builder()
      .optionallyWith(
        gateways.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.gateways)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.backupgateway.model.ListGatewaysResponse.ReadOnly =
    zio.aws.backupgateway.model.ListGatewaysResponse.wrap(buildAwsValue())
}
object ListGatewaysResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupgateway.model.ListGatewaysResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backupgateway.model.ListGatewaysResponse =
      zio.aws.backupgateway.model.ListGatewaysResponse(
        gateways.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def gateways: Optional[List[zio.aws.backupgateway.model.Gateway.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getGateways: ZIO[Any, AwsError, List[
      zio.aws.backupgateway.model.Gateway.ReadOnly
    ]] = AwsError.unwrapOptionField("gateways", gateways)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupgateway.model.ListGatewaysResponse
  ) extends zio.aws.backupgateway.model.ListGatewaysResponse.ReadOnly {
    override val gateways
        : Optional[List[zio.aws.backupgateway.model.Gateway.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gateways())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.backupgateway.model.Gateway.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.backupgateway.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupgateway.model.ListGatewaysResponse
  ): zio.aws.backupgateway.model.ListGatewaysResponse.ReadOnly = new Wrapper(
    impl
  )
}
