package zio.aws.backupgateway.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.backupgateway.model.primitives.ServerArn
import scala.jdk.CollectionConverters.*
final case class GetHypervisorPropertyMappingsRequest(
    hypervisorArn: ServerArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupgateway.model.GetHypervisorPropertyMappingsRequest = {
    import GetHypervisorPropertyMappingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupgateway.model.GetHypervisorPropertyMappingsRequest
      .builder()
      .hypervisorArn(ServerArn.unwrap(hypervisorArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.backupgateway.model.GetHypervisorPropertyMappingsRequest.ReadOnly =
    zio.aws.backupgateway.model.GetHypervisorPropertyMappingsRequest
      .wrap(buildAwsValue())
}
object GetHypervisorPropertyMappingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupgateway.model.GetHypervisorPropertyMappingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.backupgateway.model.GetHypervisorPropertyMappingsRequest =
      zio.aws.backupgateway.model
        .GetHypervisorPropertyMappingsRequest(hypervisorArn)
    def hypervisorArn: ServerArn
    def getHypervisorArn: ZIO[Any, Nothing, ServerArn] =
      ZIO.succeed(hypervisorArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupgateway.model.GetHypervisorPropertyMappingsRequest
  ) extends zio.aws.backupgateway.model.GetHypervisorPropertyMappingsRequest.ReadOnly {
    override val hypervisorArn: ServerArn =
      zio.aws.backupgateway.model.primitives.ServerArn(impl.hypervisorArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupgateway.model.GetHypervisorPropertyMappingsRequest
  ): zio.aws.backupgateway.model.GetHypervisorPropertyMappingsRequest.ReadOnly =
    new Wrapper(impl)
}
