package zio.aws.backupgateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetGatewayResponse(
    gateway: Optional[zio.aws.backupgateway.model.GatewayDetails] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupgateway.model.GetGatewayResponse = {
    import GetGatewayResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupgateway.model.GetGatewayResponse
      .builder()
      .optionallyWith(gateway.map(value => value.buildAwsValue()))(_.gateway)
      .build()
  }
  def asReadOnly: zio.aws.backupgateway.model.GetGatewayResponse.ReadOnly =
    zio.aws.backupgateway.model.GetGatewayResponse.wrap(buildAwsValue())
}
object GetGatewayResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupgateway.model.GetGatewayResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backupgateway.model.GetGatewayResponse =
      zio.aws.backupgateway.model
        .GetGatewayResponse(gateway.map(value => value.asEditable))
    def gateway: Optional[zio.aws.backupgateway.model.GatewayDetails.ReadOnly]
    def getGateway: ZIO[
      Any,
      AwsError,
      zio.aws.backupgateway.model.GatewayDetails.ReadOnly
    ] = AwsError.unwrapOptionField("gateway", gateway)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupgateway.model.GetGatewayResponse
  ) extends zio.aws.backupgateway.model.GetGatewayResponse.ReadOnly {
    override val gateway
        : Optional[zio.aws.backupgateway.model.GatewayDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gateway())
        .map(value => zio.aws.backupgateway.model.GatewayDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupgateway.model.GetGatewayResponse
  ): zio.aws.backupgateway.model.GetGatewayResponse.ReadOnly = new Wrapper(impl)
}
