package zio.aws.backupgateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.backupgateway.model.primitives.{
  Host,
  ServerArn,
  Password,
  Name,
  Username
}
import scala.jdk.CollectionConverters.*
final case class UpdateHypervisorRequest(
    host: Optional[Host] = Optional.Absent,
    hypervisorArn: ServerArn,
    name: Optional[Name] = Optional.Absent,
    password: Optional[Password] = Optional.Absent,
    username: Optional[Username] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupgateway.model.UpdateHypervisorRequest = {
    import UpdateHypervisorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupgateway.model.UpdateHypervisorRequest
      .builder()
      .optionallyWith(host.map(value => Host.unwrap(value): java.lang.String))(
        _.host
      )
      .hypervisorArn(ServerArn.unwrap(hypervisorArn): java.lang.String)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        password.map(value => Password.unwrap(value): java.lang.String)
      )(_.password)
      .optionallyWith(
        username.map(value => Username.unwrap(value): java.lang.String)
      )(_.username)
      .build()
  }
  def asReadOnly: zio.aws.backupgateway.model.UpdateHypervisorRequest.ReadOnly =
    zio.aws.backupgateway.model.UpdateHypervisorRequest.wrap(buildAwsValue())
}
object UpdateHypervisorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupgateway.model.UpdateHypervisorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backupgateway.model.UpdateHypervisorRequest =
      zio.aws.backupgateway.model.UpdateHypervisorRequest(
        host.map(value => value),
        hypervisorArn,
        name.map(value => value),
        password.map(value => value),
        username.map(value => value)
      )
    def host: Optional[Host]
    def hypervisorArn: ServerArn
    def name: Optional[Name]
    def password: Optional[Password]
    def username: Optional[Username]
    def getHost: ZIO[Any, AwsError, Host] =
      AwsError.unwrapOptionField("host", host)
    def getHypervisorArn: ZIO[Any, Nothing, ServerArn] =
      ZIO.succeed(hypervisorArn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getPassword: ZIO[Any, AwsError, Password] =
      AwsError.unwrapOptionField("password", password)
    def getUsername: ZIO[Any, AwsError, Username] =
      AwsError.unwrapOptionField("username", username)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupgateway.model.UpdateHypervisorRequest
  ) extends zio.aws.backupgateway.model.UpdateHypervisorRequest.ReadOnly {
    override val host: Optional[Host] = zio.aws.core.internal
      .optionalFromNullable(impl.host())
      .map(value => zio.aws.backupgateway.model.primitives.Host(value))
    override val hypervisorArn: ServerArn =
      zio.aws.backupgateway.model.primitives.ServerArn(impl.hypervisorArn())
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.backupgateway.model.primitives.Name(value))
    override val password: Optional[Password] = zio.aws.core.internal
      .optionalFromNullable(impl.password())
      .map(value => zio.aws.backupgateway.model.primitives.Password(value))
    override val username: Optional[Username] = zio.aws.core.internal
      .optionalFromNullable(impl.username())
      .map(value => zio.aws.backupgateway.model.primitives.Username(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupgateway.model.UpdateHypervisorRequest
  ): zio.aws.backupgateway.model.UpdateHypervisorRequest.ReadOnly = new Wrapper(
    impl
  )
}
