package zio.aws.backupgateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.backupgateway.model.primitives.{
  Host,
  Password,
  KmsKeyArn,
  Name,
  Username
}
import scala.jdk.CollectionConverters.*
final case class ImportHypervisorConfigurationRequest(
    host: Host,
    kmsKeyArn: Optional[KmsKeyArn] = Optional.Absent,
    name: Name,
    password: Optional[Password] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.backupgateway.model.Tag]] = Optional.Absent,
    username: Optional[Username] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupgateway.model.ImportHypervisorConfigurationRequest = {
    import ImportHypervisorConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupgateway.model.ImportHypervisorConfigurationRequest
      .builder()
      .host(Host.unwrap(host): java.lang.String)
      .optionallyWith(
        kmsKeyArn.map(value => KmsKeyArn.unwrap(value): java.lang.String)
      )(_.kmsKeyArn)
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        password.map(value => Password.unwrap(value): java.lang.String)
      )(_.password)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        username.map(value => Username.unwrap(value): java.lang.String)
      )(_.username)
      .build()
  }
  def asReadOnly
      : zio.aws.backupgateway.model.ImportHypervisorConfigurationRequest.ReadOnly =
    zio.aws.backupgateway.model.ImportHypervisorConfigurationRequest
      .wrap(buildAwsValue())
}
object ImportHypervisorConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupgateway.model.ImportHypervisorConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.backupgateway.model.ImportHypervisorConfigurationRequest =
      zio.aws.backupgateway.model.ImportHypervisorConfigurationRequest(
        host,
        kmsKeyArn.map(value => value),
        name,
        password.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        username.map(value => value)
      )
    def host: Host
    def kmsKeyArn: Optional[KmsKeyArn]
    def name: Name
    def password: Optional[Password]
    def tags: Optional[List[zio.aws.backupgateway.model.Tag.ReadOnly]]
    def username: Optional[Username]
    def getHost: ZIO[Any, Nothing, Host] = ZIO.succeed(host)
    def getKmsKeyArn: ZIO[Any, AwsError, KmsKeyArn] =
      AwsError.unwrapOptionField("kmsKeyArn", kmsKeyArn)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getPassword: ZIO[Any, AwsError, Password] =
      AwsError.unwrapOptionField("password", password)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.backupgateway.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getUsername: ZIO[Any, AwsError, Username] =
      AwsError.unwrapOptionField("username", username)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupgateway.model.ImportHypervisorConfigurationRequest
  ) extends zio.aws.backupgateway.model.ImportHypervisorConfigurationRequest.ReadOnly {
    override val host: Host =
      zio.aws.backupgateway.model.primitives.Host(impl.host())
    override val kmsKeyArn: Optional[KmsKeyArn] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyArn())
      .map(value => zio.aws.backupgateway.model.primitives.KmsKeyArn(value))
    override val name: Name =
      zio.aws.backupgateway.model.primitives.Name(impl.name())
    override val password: Optional[Password] = zio.aws.core.internal
      .optionalFromNullable(impl.password())
      .map(value => zio.aws.backupgateway.model.primitives.Password(value))
    override val tags
        : Optional[List[zio.aws.backupgateway.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.backupgateway.model.Tag.wrap(item)
          }.toList
        )
    override val username: Optional[Username] = zio.aws.core.internal
      .optionalFromNullable(impl.username())
      .map(value => zio.aws.backupgateway.model.primitives.Username(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupgateway.model.ImportHypervisorConfigurationRequest
  ): zio.aws.backupgateway.model.ImportHypervisorConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
