package zio.aws.backupgateway.model
import scala.jdk.CollectionConverters.*
sealed trait HypervisorState {
  def unwrap
      : software.amazon.awssdk.services.backupgateway.model.HypervisorState
}
object HypervisorState {
  def wrap(
      value: software.amazon.awssdk.services.backupgateway.model.HypervisorState
  ): zio.aws.backupgateway.model.HypervisorState = value match {
    case software.amazon.awssdk.services.backupgateway.model.HypervisorState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.backupgateway.model.HypervisorState.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.backupgateway.model.HypervisorState.ONLINE =>
      val r = ONLINE
      r
    case software.amazon.awssdk.services.backupgateway.model.HypervisorState.OFFLINE =>
      val r = OFFLINE
      r
    case software.amazon.awssdk.services.backupgateway.model.HypervisorState.ERROR =>
      val r = ERROR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.backupgateway.model.HypervisorState {
    override def unwrap
        : software.amazon.awssdk.services.backupgateway.model.HypervisorState =
      software.amazon.awssdk.services.backupgateway.model.HypervisorState.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.backupgateway.model.HypervisorState {
    override def unwrap
        : software.amazon.awssdk.services.backupgateway.model.HypervisorState =
      software.amazon.awssdk.services.backupgateway.model.HypervisorState.PENDING
  }
  case object ONLINE extends zio.aws.backupgateway.model.HypervisorState {
    override def unwrap
        : software.amazon.awssdk.services.backupgateway.model.HypervisorState =
      software.amazon.awssdk.services.backupgateway.model.HypervisorState.ONLINE
  }
  case object OFFLINE extends zio.aws.backupgateway.model.HypervisorState {
    override def unwrap
        : software.amazon.awssdk.services.backupgateway.model.HypervisorState =
      software.amazon.awssdk.services.backupgateway.model.HypervisorState.OFFLINE
  }
  case object ERROR extends zio.aws.backupgateway.model.HypervisorState {
    override def unwrap
        : software.amazon.awssdk.services.backupgateway.model.HypervisorState =
      software.amazon.awssdk.services.backupgateway.model.HypervisorState.ERROR
  }
}
