package zio.aws.backupgateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.backupgateway.model.primitives.{Name, KmsKeyArn, ServerArn, Host}
import scala.jdk.CollectionConverters.*
final case class Hypervisor(
    host: Optional[Host] = Optional.Absent,
    hypervisorArn: Optional[ServerArn] = Optional.Absent,
    kmsKeyArn: Optional[KmsKeyArn] = Optional.Absent,
    name: Optional[Name] = Optional.Absent,
    state: Optional[zio.aws.backupgateway.model.HypervisorState] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupgateway.model.Hypervisor = {
    import Hypervisor.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupgateway.model.Hypervisor
      .builder()
      .optionallyWith(host.map(value => Host.unwrap(value): java.lang.String))(
        _.host
      )
      .optionallyWith(
        hypervisorArn.map(value => ServerArn.unwrap(value): java.lang.String)
      )(_.hypervisorArn)
      .optionallyWith(
        kmsKeyArn.map(value => KmsKeyArn.unwrap(value): java.lang.String)
      )(_.kmsKeyArn)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.backupgateway.model.Hypervisor.ReadOnly =
    zio.aws.backupgateway.model.Hypervisor.wrap(buildAwsValue())
}
object Hypervisor {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupgateway.model.Hypervisor
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backupgateway.model.Hypervisor =
      zio.aws.backupgateway.model.Hypervisor(
        host.map(value => value),
        hypervisorArn.map(value => value),
        kmsKeyArn.map(value => value),
        name.map(value => value),
        state.map(value => value)
      )
    def host: Optional[Host]
    def hypervisorArn: Optional[ServerArn]
    def kmsKeyArn: Optional[KmsKeyArn]
    def name: Optional[Name]
    def state: Optional[zio.aws.backupgateway.model.HypervisorState]
    def getHost: ZIO[Any, AwsError, Host] =
      AwsError.unwrapOptionField("host", host)
    def getHypervisorArn: ZIO[Any, AwsError, ServerArn] =
      AwsError.unwrapOptionField("hypervisorArn", hypervisorArn)
    def getKmsKeyArn: ZIO[Any, AwsError, KmsKeyArn] =
      AwsError.unwrapOptionField("kmsKeyArn", kmsKeyArn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getState
        : ZIO[Any, AwsError, zio.aws.backupgateway.model.HypervisorState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupgateway.model.Hypervisor
  ) extends zio.aws.backupgateway.model.Hypervisor.ReadOnly {
    override val host: Optional[Host] = zio.aws.core.internal
      .optionalFromNullable(impl.host())
      .map(value => zio.aws.backupgateway.model.primitives.Host(value))
    override val hypervisorArn: Optional[ServerArn] = zio.aws.core.internal
      .optionalFromNullable(impl.hypervisorArn())
      .map(value => zio.aws.backupgateway.model.primitives.ServerArn(value))
    override val kmsKeyArn: Optional[KmsKeyArn] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyArn())
      .map(value => zio.aws.backupgateway.model.primitives.KmsKeyArn(value))
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.backupgateway.model.primitives.Name(value))
    override val state: Optional[zio.aws.backupgateway.model.HypervisorState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.backupgateway.model.HypervisorState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupgateway.model.Hypervisor
  ): zio.aws.backupgateway.model.Hypervisor.ReadOnly = new Wrapper(impl)
}
