package zio.aws.backupgateway
import zio.aws.backupgateway.model.TestHypervisorConfigurationResponse.ReadOnly
import software.amazon.awssdk.services.backupgateway.BackupGatewayAsyncClient
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.backupgateway.model.{
  DeleteGatewayRequest,
  ListVirtualMachinesRequest,
  DisassociateGatewayFromServerRequest,
  UpdateGatewaySoftwareNowRequest,
  ListTagsForResourceRequest,
  ImportHypervisorConfigurationRequest,
  GetGatewayRequest,
  PutMaintenanceStartTimeRequest,
  UntagResourceRequest,
  AssociateGatewayToServerRequest,
  CreateGatewayRequest,
  ListHypervisorsRequest,
  DeleteHypervisorRequest,
  TestHypervisorConfigurationRequest,
  UpdateHypervisorRequest,
  ListGatewaysRequest,
  TagResourceRequest,
  UpdateGatewayInformationRequest
}
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object BackupGatewayMock extends Mock[BackupGateway] {
  object DisassociateGatewayFromServer
      extends Effect[
        DisassociateGatewayFromServerRequest,
        AwsError,
        zio.aws.backupgateway.model.DisassociateGatewayFromServerResponse.ReadOnly
      ]
  object ListHypervisors
      extends Stream[
        ListHypervisorsRequest,
        AwsError,
        zio.aws.backupgateway.model.Hypervisor.ReadOnly
      ]
  object ListHypervisorsPaginated
      extends Effect[
        ListHypervisorsRequest,
        AwsError,
        zio.aws.backupgateway.model.ListHypervisorsResponse.ReadOnly
      ]
  object ImportHypervisorConfiguration
      extends Effect[
        ImportHypervisorConfigurationRequest,
        AwsError,
        zio.aws.backupgateway.model.ImportHypervisorConfigurationResponse.ReadOnly
      ]
  object CreateGateway
      extends Effect[
        CreateGatewayRequest,
        AwsError,
        zio.aws.backupgateway.model.CreateGatewayResponse.ReadOnly
      ]
  object UpdateGatewayInformation
      extends Effect[
        UpdateGatewayInformationRequest,
        AwsError,
        zio.aws.backupgateway.model.UpdateGatewayInformationResponse.ReadOnly
      ]
  object DeleteGateway
      extends Effect[
        DeleteGatewayRequest,
        AwsError,
        zio.aws.backupgateway.model.DeleteGatewayResponse.ReadOnly
      ]
  object UpdateHypervisor
      extends Effect[
        UpdateHypervisorRequest,
        AwsError,
        zio.aws.backupgateway.model.UpdateHypervisorResponse.ReadOnly
      ]
  object TestHypervisorConfiguration
      extends Effect[TestHypervisorConfigurationRequest, AwsError, ReadOnly]
  object DeleteHypervisor
      extends Effect[
        DeleteHypervisorRequest,
        AwsError,
        zio.aws.backupgateway.model.DeleteHypervisorResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.backupgateway.model.UntagResourceResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.backupgateway.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.backupgateway.model.TagResourceResponse.ReadOnly
      ]
  object UpdateGatewaySoftwareNow
      extends Effect[
        UpdateGatewaySoftwareNowRequest,
        AwsError,
        zio.aws.backupgateway.model.UpdateGatewaySoftwareNowResponse.ReadOnly
      ]
  object PutMaintenanceStartTime
      extends Effect[
        PutMaintenanceStartTimeRequest,
        AwsError,
        zio.aws.backupgateway.model.PutMaintenanceStartTimeResponse.ReadOnly
      ]
  object GetGateway
      extends Effect[
        GetGatewayRequest,
        AwsError,
        zio.aws.backupgateway.model.GetGatewayResponse.ReadOnly
      ]
  object AssociateGatewayToServer
      extends Effect[
        AssociateGatewayToServerRequest,
        AwsError,
        zio.aws.backupgateway.model.AssociateGatewayToServerResponse.ReadOnly
      ]
  object ListGateways
      extends Stream[
        ListGatewaysRequest,
        AwsError,
        zio.aws.backupgateway.model.Gateway.ReadOnly
      ]
  object ListGatewaysPaginated
      extends Effect[
        ListGatewaysRequest,
        AwsError,
        zio.aws.backupgateway.model.ListGatewaysResponse.ReadOnly
      ]
  object ListVirtualMachines
      extends Stream[
        ListVirtualMachinesRequest,
        AwsError,
        zio.aws.backupgateway.model.VirtualMachine.ReadOnly
      ]
  object ListVirtualMachinesPaginated
      extends Effect[
        ListVirtualMachinesRequest,
        AwsError,
        zio.aws.backupgateway.model.ListVirtualMachinesResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, BackupGateway] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, BackupGateway] { rts =>
        zio.ZIO.succeed {
          new BackupGateway {
            val api: BackupGatewayAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): BackupGateway = this
            def disassociateGatewayFromServer(
                request: DisassociateGatewayFromServerRequest
            ): IO[
              AwsError,
              zio.aws.backupgateway.model.DisassociateGatewayFromServerResponse.ReadOnly
            ] = proxy(DisassociateGatewayFromServer, request)
            def listHypervisors(request: ListHypervisorsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.backupgateway.model.Hypervisor.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListHypervisors, request)
                }
                .getOrThrowFiberFailure()
            }
            def listHypervisorsPaginated(request: ListHypervisorsRequest): IO[
              AwsError,
              zio.aws.backupgateway.model.ListHypervisorsResponse.ReadOnly
            ] = proxy(ListHypervisorsPaginated, request)
            def importHypervisorConfiguration(
                request: ImportHypervisorConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.backupgateway.model.ImportHypervisorConfigurationResponse.ReadOnly
            ] = proxy(ImportHypervisorConfiguration, request)
            def createGateway(request: CreateGatewayRequest): IO[
              AwsError,
              zio.aws.backupgateway.model.CreateGatewayResponse.ReadOnly
            ] = proxy(CreateGateway, request)
            def updateGatewayInformation(
                request: UpdateGatewayInformationRequest
            ): IO[
              AwsError,
              zio.aws.backupgateway.model.UpdateGatewayInformationResponse.ReadOnly
            ] = proxy(UpdateGatewayInformation, request)
            def deleteGateway(request: DeleteGatewayRequest): IO[
              AwsError,
              zio.aws.backupgateway.model.DeleteGatewayResponse.ReadOnly
            ] = proxy(DeleteGateway, request)
            def updateHypervisor(request: UpdateHypervisorRequest): IO[
              AwsError,
              zio.aws.backupgateway.model.UpdateHypervisorResponse.ReadOnly
            ] = proxy(UpdateHypervisor, request)
            def testHypervisorConfiguration(
                request: TestHypervisorConfigurationRequest
            ): IO[AwsError, ReadOnly] =
              proxy(TestHypervisorConfiguration, request)
            def deleteHypervisor(request: DeleteHypervisorRequest): IO[
              AwsError,
              zio.aws.backupgateway.model.DeleteHypervisorResponse.ReadOnly
            ] = proxy(DeleteHypervisor, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.backupgateway.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.backupgateway.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.backupgateway.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def updateGatewaySoftwareNow(
                request: UpdateGatewaySoftwareNowRequest
            ): IO[
              AwsError,
              zio.aws.backupgateway.model.UpdateGatewaySoftwareNowResponse.ReadOnly
            ] = proxy(UpdateGatewaySoftwareNow, request)
            def putMaintenanceStartTime(
                request: PutMaintenanceStartTimeRequest
            ): IO[
              AwsError,
              zio.aws.backupgateway.model.PutMaintenanceStartTimeResponse.ReadOnly
            ] = proxy(PutMaintenanceStartTime, request)
            def getGateway(request: GetGatewayRequest): IO[
              AwsError,
              zio.aws.backupgateway.model.GetGatewayResponse.ReadOnly
            ] = proxy(GetGateway, request)
            def associateGatewayToServer(
                request: AssociateGatewayToServerRequest
            ): IO[
              AwsError,
              zio.aws.backupgateway.model.AssociateGatewayToServerResponse.ReadOnly
            ] = proxy(AssociateGatewayToServer, request)
            def listGateways(request: ListGatewaysRequest): ZStream[
              Any,
              AwsError,
              zio.aws.backupgateway.model.Gateway.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListGateways, request)
                }
                .getOrThrowFiberFailure()
            }
            def listGatewaysPaginated(request: ListGatewaysRequest): IO[
              AwsError,
              zio.aws.backupgateway.model.ListGatewaysResponse.ReadOnly
            ] = proxy(ListGatewaysPaginated, request)
            def listVirtualMachines(
                request: ListVirtualMachinesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.backupgateway.model.VirtualMachine.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListVirtualMachines, request)
                }
                .getOrThrowFiberFailure()
            }
            def listVirtualMachinesPaginated(
                request: ListVirtualMachinesRequest
            ): IO[
              AwsError,
              zio.aws.backupgateway.model.ListVirtualMachinesResponse.ReadOnly
            ] = proxy(ListVirtualMachinesPaginated, request)
          }
        }
      }
    }
  }
}
