package zio.aws.backupgateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backupgateway.model.primitives.GatewayArn
import scala.jdk.CollectionConverters.*
final case class UpdateGatewayInformationResponse(
    gatewayArn: Option[GatewayArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupgateway.model.UpdateGatewayInformationResponse = {
    import UpdateGatewayInformationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupgateway.model.UpdateGatewayInformationResponse
      .builder()
      .optionallyWith(
        gatewayArn.map(value => GatewayArn.unwrap(value): java.lang.String)
      )(_.gatewayArn)
      .build()
  }
  def asReadOnly
      : zio.aws.backupgateway.model.UpdateGatewayInformationResponse.ReadOnly =
    zio.aws.backupgateway.model.UpdateGatewayInformationResponse
      .wrap(buildAwsValue())
}
object UpdateGatewayInformationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupgateway.model.UpdateGatewayInformationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.backupgateway.model.UpdateGatewayInformationResponse =
      zio.aws.backupgateway.model
        .UpdateGatewayInformationResponse(gatewayArn.map(value => value))
    def gatewayArn: Option[GatewayArn]
    def getGatewayArn: ZIO[Any, AwsError, GatewayArn] =
      AwsError.unwrapOptionField("gatewayArn", gatewayArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupgateway.model.UpdateGatewayInformationResponse
  ) extends zio.aws.backupgateway.model.UpdateGatewayInformationResponse.ReadOnly {
    override val gatewayArn: Option[GatewayArn] = scala
      .Option(impl.gatewayArn())
      .map(value => zio.aws.backupgateway.model.primitives.GatewayArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupgateway.model.UpdateGatewayInformationResponse
  ): zio.aws.backupgateway.model.UpdateGatewayInformationResponse.ReadOnly =
    new Wrapper(impl)
}
