package zio.aws.backupgateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backupgateway.model.primitives.{Name, GatewayArn}
import scala.jdk.CollectionConverters.*
final case class UpdateGatewayInformationRequest(
    gatewayArn: GatewayArn,
    gatewayDisplayName: Option[Name] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupgateway.model.UpdateGatewayInformationRequest = {
    import UpdateGatewayInformationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupgateway.model.UpdateGatewayInformationRequest
      .builder()
      .gatewayArn(GatewayArn.unwrap(gatewayArn): java.lang.String)
      .optionallyWith(
        gatewayDisplayName.map(value => Name.unwrap(value): java.lang.String)
      )(_.gatewayDisplayName)
      .build()
  }
  def asReadOnly
      : zio.aws.backupgateway.model.UpdateGatewayInformationRequest.ReadOnly =
    zio.aws.backupgateway.model.UpdateGatewayInformationRequest
      .wrap(buildAwsValue())
}
object UpdateGatewayInformationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupgateway.model.UpdateGatewayInformationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.backupgateway.model.UpdateGatewayInformationRequest =
      zio.aws.backupgateway.model.UpdateGatewayInformationRequest(
        gatewayArn,
        gatewayDisplayName.map(value => value)
      )
    def gatewayArn: GatewayArn
    def gatewayDisplayName: Option[Name]
    def getGatewayArn: ZIO[Any, Nothing, GatewayArn] = ZIO.succeed(gatewayArn)
    def getGatewayDisplayName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("gatewayDisplayName", gatewayDisplayName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupgateway.model.UpdateGatewayInformationRequest
  ) extends zio.aws.backupgateway.model.UpdateGatewayInformationRequest.ReadOnly {
    override val gatewayArn: GatewayArn =
      zio.aws.backupgateway.model.primitives.GatewayArn(impl.gatewayArn())
    override val gatewayDisplayName: Option[Name] = scala
      .Option(impl.gatewayDisplayName())
      .map(value => zio.aws.backupgateway.model.primitives.Name(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupgateway.model.UpdateGatewayInformationRequest
  ): zio.aws.backupgateway.model.UpdateGatewayInformationRequest.ReadOnly =
    new Wrapper(impl)
}
