package zio.aws.backupgateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backupgateway.model.primitives.ResourceArn
import scala.jdk.CollectionConverters.*
final case class UntagResourceResponse(
    resourceARN: Option[ResourceArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupgateway.model.UntagResourceResponse = {
    import UntagResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupgateway.model.UntagResourceResponse
      .builder()
      .optionallyWith(
        resourceARN.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.resourceARN)
      .build()
  }
  def asReadOnly: zio.aws.backupgateway.model.UntagResourceResponse.ReadOnly =
    zio.aws.backupgateway.model.UntagResourceResponse.wrap(buildAwsValue())
}
object UntagResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupgateway.model.UntagResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backupgateway.model.UntagResourceResponse =
      zio.aws.backupgateway.model
        .UntagResourceResponse(resourceARN.map(value => value))
    def resourceARN: Option[ResourceArn]
    def getResourceARN: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("resourceARN", resourceARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupgateway.model.UntagResourceResponse
  ) extends zio.aws.backupgateway.model.UntagResourceResponse.ReadOnly {
    override val resourceARN: Option[ResourceArn] = scala
      .Option(impl.resourceARN())
      .map(value => zio.aws.backupgateway.model.primitives.ResourceArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupgateway.model.UntagResourceResponse
  ): zio.aws.backupgateway.model.UntagResourceResponse.ReadOnly = new Wrapper(
    impl
  )
}
