package zio.aws.backupgateway.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backupgateway.model.primitives.{
  GatewayArn,
  HourOfDay,
  DayOfWeek,
  MinuteOfHour,
  DayOfMonth
}
import scala.jdk.CollectionConverters.*
final case class PutMaintenanceStartTimeRequest(
    dayOfMonth: Option[DayOfMonth] = None,
    dayOfWeek: Option[DayOfWeek] = None,
    gatewayArn: GatewayArn,
    hourOfDay: HourOfDay,
    minuteOfHour: MinuteOfHour
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupgateway.model.PutMaintenanceStartTimeRequest = {
    import PutMaintenanceStartTimeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupgateway.model.PutMaintenanceStartTimeRequest
      .builder()
      .optionallyWith(
        dayOfMonth.map(value => DayOfMonth.unwrap(value): Integer)
      )(_.dayOfMonth)
      .optionallyWith(dayOfWeek.map(value => DayOfWeek.unwrap(value): Integer))(
        _.dayOfWeek
      )
      .gatewayArn(GatewayArn.unwrap(gatewayArn): java.lang.String)
      .hourOfDay(HourOfDay.unwrap(hourOfDay): Integer)
      .minuteOfHour(MinuteOfHour.unwrap(minuteOfHour): Integer)
      .build()
  }
  def asReadOnly
      : zio.aws.backupgateway.model.PutMaintenanceStartTimeRequest.ReadOnly =
    zio.aws.backupgateway.model.PutMaintenanceStartTimeRequest
      .wrap(buildAwsValue())
}
object PutMaintenanceStartTimeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupgateway.model.PutMaintenanceStartTimeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backupgateway.model.PutMaintenanceStartTimeRequest =
      zio.aws.backupgateway.model.PutMaintenanceStartTimeRequest(
        dayOfMonth.map(value => value),
        dayOfWeek.map(value => value),
        gatewayArn,
        hourOfDay,
        minuteOfHour
      )
    def dayOfMonth: Option[DayOfMonth]
    def dayOfWeek: Option[DayOfWeek]
    def gatewayArn: GatewayArn
    def hourOfDay: HourOfDay
    def minuteOfHour: MinuteOfHour
    def getDayOfMonth: ZIO[Any, AwsError, DayOfMonth] =
      AwsError.unwrapOptionField("dayOfMonth", dayOfMonth)
    def getDayOfWeek: ZIO[Any, AwsError, DayOfWeek] =
      AwsError.unwrapOptionField("dayOfWeek", dayOfWeek)
    def getGatewayArn: ZIO[Any, Nothing, GatewayArn] = ZIO.succeed(gatewayArn)
    def getHourOfDay: ZIO[Any, Nothing, HourOfDay] = ZIO.succeed(hourOfDay)
    def getMinuteOfHour: ZIO[Any, Nothing, MinuteOfHour] =
      ZIO.succeed(minuteOfHour)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupgateway.model.PutMaintenanceStartTimeRequest
  ) extends zio.aws.backupgateway.model.PutMaintenanceStartTimeRequest.ReadOnly {
    override val dayOfMonth: Option[DayOfMonth] = scala
      .Option(impl.dayOfMonth())
      .map(value => zio.aws.backupgateway.model.primitives.DayOfMonth(value))
    override val dayOfWeek: Option[DayOfWeek] = scala
      .Option(impl.dayOfWeek())
      .map(value => zio.aws.backupgateway.model.primitives.DayOfWeek(value))
    override val gatewayArn: GatewayArn =
      zio.aws.backupgateway.model.primitives.GatewayArn(impl.gatewayArn())
    override val hourOfDay: HourOfDay =
      zio.aws.backupgateway.model.primitives.HourOfDay(impl.hourOfDay())
    override val minuteOfHour: MinuteOfHour =
      zio.aws.backupgateway.model.primitives.MinuteOfHour(impl.minuteOfHour())
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupgateway.model.PutMaintenanceStartTimeRequest
  ): zio.aws.backupgateway.model.PutMaintenanceStartTimeRequest.ReadOnly =
    new Wrapper(impl)
}
