package zio.aws.backupgateway.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backupgateway.model.primitives.{NextToken, MaxResults}
import scala.jdk.CollectionConverters.*
final case class ListVirtualMachinesRequest(
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupgateway.model.ListVirtualMachinesRequest = {
    import ListVirtualMachinesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupgateway.model.ListVirtualMachinesRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.backupgateway.model.ListVirtualMachinesRequest.ReadOnly =
    zio.aws.backupgateway.model.ListVirtualMachinesRequest.wrap(buildAwsValue())
}
object ListVirtualMachinesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupgateway.model.ListVirtualMachinesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backupgateway.model.ListVirtualMachinesRequest =
      zio.aws.backupgateway.model.ListVirtualMachinesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupgateway.model.ListVirtualMachinesRequest
  ) extends zio.aws.backupgateway.model.ListVirtualMachinesRequest.ReadOnly {
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.backupgateway.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.backupgateway.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupgateway.model.ListVirtualMachinesRequest
  ): zio.aws.backupgateway.model.ListVirtualMachinesRequest.ReadOnly =
    new Wrapper(impl)
}
