package zio.aws.backupgateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backupgateway.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListGatewaysResponse(
    gateways: Option[Iterable[zio.aws.backupgateway.model.Gateway]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupgateway.model.ListGatewaysResponse = {
    import ListGatewaysResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupgateway.model.ListGatewaysResponse
      .builder()
      .optionallyWith(
        gateways.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.gateways)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.backupgateway.model.ListGatewaysResponse.ReadOnly =
    zio.aws.backupgateway.model.ListGatewaysResponse.wrap(buildAwsValue())
}
object ListGatewaysResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupgateway.model.ListGatewaysResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backupgateway.model.ListGatewaysResponse =
      zio.aws.backupgateway.model.ListGatewaysResponse(
        gateways.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def gateways: Option[List[zio.aws.backupgateway.model.Gateway.ReadOnly]]
    def nextToken: Option[NextToken]
    def getGateways: ZIO[Any, AwsError, List[
      zio.aws.backupgateway.model.Gateway.ReadOnly
    ]] = AwsError.unwrapOptionField("gateways", gateways)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupgateway.model.ListGatewaysResponse
  ) extends zio.aws.backupgateway.model.ListGatewaysResponse.ReadOnly {
    override val gateways
        : Option[List[zio.aws.backupgateway.model.Gateway.ReadOnly]] = scala
      .Option(impl.gateways())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.backupgateway.model.Gateway.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.backupgateway.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupgateway.model.ListGatewaysResponse
  ): zio.aws.backupgateway.model.ListGatewaysResponse.ReadOnly = new Wrapper(
    impl
  )
}
