package zio.aws.backupgateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backupgateway.model.primitives.{
  Host,
  Password,
  KmsKeyArn,
  Name,
  Username
}
import scala.jdk.CollectionConverters.*
final case class ImportHypervisorConfigurationRequest(
    host: Host,
    kmsKeyArn: Option[KmsKeyArn] = None,
    name: Name,
    password: Option[Password] = None,
    tags: Option[Iterable[zio.aws.backupgateway.model.Tag]] = None,
    username: Option[Username] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupgateway.model.ImportHypervisorConfigurationRequest = {
    import ImportHypervisorConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupgateway.model.ImportHypervisorConfigurationRequest
      .builder()
      .host(Host.unwrap(host): java.lang.String)
      .optionallyWith(
        kmsKeyArn.map(value => KmsKeyArn.unwrap(value): java.lang.String)
      )(_.kmsKeyArn)
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        password.map(value => Password.unwrap(value): java.lang.String)
      )(_.password)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        username.map(value => Username.unwrap(value): java.lang.String)
      )(_.username)
      .build()
  }
  def asReadOnly
      : zio.aws.backupgateway.model.ImportHypervisorConfigurationRequest.ReadOnly =
    zio.aws.backupgateway.model.ImportHypervisorConfigurationRequest
      .wrap(buildAwsValue())
}
object ImportHypervisorConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupgateway.model.ImportHypervisorConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.backupgateway.model.ImportHypervisorConfigurationRequest =
      zio.aws.backupgateway.model.ImportHypervisorConfigurationRequest(
        host,
        kmsKeyArn.map(value => value),
        name,
        password.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        username.map(value => value)
      )
    def host: Host
    def kmsKeyArn: Option[KmsKeyArn]
    def name: Name
    def password: Option[Password]
    def tags: Option[List[zio.aws.backupgateway.model.Tag.ReadOnly]]
    def username: Option[Username]
    def getHost: ZIO[Any, Nothing, Host] = ZIO.succeed(host)
    def getKmsKeyArn: ZIO[Any, AwsError, KmsKeyArn] =
      AwsError.unwrapOptionField("kmsKeyArn", kmsKeyArn)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getPassword: ZIO[Any, AwsError, Password] =
      AwsError.unwrapOptionField("password", password)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.backupgateway.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getUsername: ZIO[Any, AwsError, Username] =
      AwsError.unwrapOptionField("username", username)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupgateway.model.ImportHypervisorConfigurationRequest
  ) extends zio.aws.backupgateway.model.ImportHypervisorConfigurationRequest.ReadOnly {
    override val host: Host =
      zio.aws.backupgateway.model.primitives.Host(impl.host())
    override val kmsKeyArn: Option[KmsKeyArn] = scala
      .Option(impl.kmsKeyArn())
      .map(value => zio.aws.backupgateway.model.primitives.KmsKeyArn(value))
    override val name: Name =
      zio.aws.backupgateway.model.primitives.Name(impl.name())
    override val password: Option[Password] = scala
      .Option(impl.password())
      .map(value => zio.aws.backupgateway.model.primitives.Password(value))
    override val tags: Option[List[zio.aws.backupgateway.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.backupgateway.model.Tag.wrap(item)
          }.toList
        )
    override val username: Option[Username] = scala
      .Option(impl.username())
      .map(value => zio.aws.backupgateway.model.primitives.Username(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupgateway.model.ImportHypervisorConfigurationRequest
  ): zio.aws.backupgateway.model.ImportHypervisorConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
