package zio.aws.backupgateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backupgateway.model.primitives.{Name, KmsKeyArn, ServerArn, Host}
import scala.jdk.CollectionConverters.*
final case class Hypervisor(
    host: Option[Host] = None,
    hypervisorArn: Option[ServerArn] = None,
    kmsKeyArn: Option[KmsKeyArn] = None,
    name: Option[Name] = None,
    state: Option[zio.aws.backupgateway.model.HypervisorState] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupgateway.model.Hypervisor = {
    import Hypervisor.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupgateway.model.Hypervisor
      .builder()
      .optionallyWith(host.map(value => Host.unwrap(value): java.lang.String))(
        _.host
      )
      .optionallyWith(
        hypervisorArn.map(value => ServerArn.unwrap(value): java.lang.String)
      )(_.hypervisorArn)
      .optionallyWith(
        kmsKeyArn.map(value => KmsKeyArn.unwrap(value): java.lang.String)
      )(_.kmsKeyArn)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.backupgateway.model.Hypervisor.ReadOnly =
    zio.aws.backupgateway.model.Hypervisor.wrap(buildAwsValue())
}
object Hypervisor {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupgateway.model.Hypervisor
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backupgateway.model.Hypervisor =
      zio.aws.backupgateway.model.Hypervisor(
        host.map(value => value),
        hypervisorArn.map(value => value),
        kmsKeyArn.map(value => value),
        name.map(value => value),
        state.map(value => value)
      )
    def host: Option[Host]
    def hypervisorArn: Option[ServerArn]
    def kmsKeyArn: Option[KmsKeyArn]
    def name: Option[Name]
    def state: Option[zio.aws.backupgateway.model.HypervisorState]
    def getHost: ZIO[Any, AwsError, Host] =
      AwsError.unwrapOptionField("host", host)
    def getHypervisorArn: ZIO[Any, AwsError, ServerArn] =
      AwsError.unwrapOptionField("hypervisorArn", hypervisorArn)
    def getKmsKeyArn: ZIO[Any, AwsError, KmsKeyArn] =
      AwsError.unwrapOptionField("kmsKeyArn", kmsKeyArn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getState
        : ZIO[Any, AwsError, zio.aws.backupgateway.model.HypervisorState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupgateway.model.Hypervisor
  ) extends zio.aws.backupgateway.model.Hypervisor.ReadOnly {
    override val host: Option[Host] = scala
      .Option(impl.host())
      .map(value => zio.aws.backupgateway.model.primitives.Host(value))
    override val hypervisorArn: Option[ServerArn] = scala
      .Option(impl.hypervisorArn())
      .map(value => zio.aws.backupgateway.model.primitives.ServerArn(value))
    override val kmsKeyArn: Option[KmsKeyArn] = scala
      .Option(impl.kmsKeyArn())
      .map(value => zio.aws.backupgateway.model.primitives.KmsKeyArn(value))
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.backupgateway.model.primitives.Name(value))
    override val state: Option[zio.aws.backupgateway.model.HypervisorState] =
      scala
        .Option(impl.state())
        .map(value => zio.aws.backupgateway.model.HypervisorState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupgateway.model.Hypervisor
  ): zio.aws.backupgateway.model.Hypervisor.ReadOnly = new Wrapper(impl)
}
