package zio.aws.backupgateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backupgateway.model.primitives.GatewayArn
import scala.jdk.CollectionConverters.*
final case class DisassociateGatewayFromServerResponse(
    gatewayArn: Option[GatewayArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupgateway.model.DisassociateGatewayFromServerResponse = {
    import DisassociateGatewayFromServerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupgateway.model.DisassociateGatewayFromServerResponse
      .builder()
      .optionallyWith(
        gatewayArn.map(value => GatewayArn.unwrap(value): java.lang.String)
      )(_.gatewayArn)
      .build()
  }
  def asReadOnly
      : zio.aws.backupgateway.model.DisassociateGatewayFromServerResponse.ReadOnly =
    zio.aws.backupgateway.model.DisassociateGatewayFromServerResponse
      .wrap(buildAwsValue())
}
object DisassociateGatewayFromServerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupgateway.model.DisassociateGatewayFromServerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.backupgateway.model.DisassociateGatewayFromServerResponse =
      zio.aws.backupgateway.model
        .DisassociateGatewayFromServerResponse(gatewayArn.map(value => value))
    def gatewayArn: Option[GatewayArn]
    def getGatewayArn: ZIO[Any, AwsError, GatewayArn] =
      AwsError.unwrapOptionField("gatewayArn", gatewayArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupgateway.model.DisassociateGatewayFromServerResponse
  ) extends zio.aws.backupgateway.model.DisassociateGatewayFromServerResponse.ReadOnly {
    override val gatewayArn: Option[GatewayArn] = scala
      .Option(impl.gatewayArn())
      .map(value => zio.aws.backupgateway.model.primitives.GatewayArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupgateway.model.DisassociateGatewayFromServerResponse
  ): zio.aws.backupgateway.model.DisassociateGatewayFromServerResponse.ReadOnly =
    new Wrapper(impl)
}
