package zio.aws.backupgateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backupgateway.model.primitives.GatewayArn
import scala.jdk.CollectionConverters.*
final case class AssociateGatewayToServerResponse(
    gatewayArn: Option[GatewayArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupgateway.model.AssociateGatewayToServerResponse = {
    import AssociateGatewayToServerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupgateway.model.AssociateGatewayToServerResponse
      .builder()
      .optionallyWith(
        gatewayArn.map(value => GatewayArn.unwrap(value): java.lang.String)
      )(_.gatewayArn)
      .build()
  }
  def asReadOnly
      : zio.aws.backupgateway.model.AssociateGatewayToServerResponse.ReadOnly =
    zio.aws.backupgateway.model.AssociateGatewayToServerResponse
      .wrap(buildAwsValue())
}
object AssociateGatewayToServerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupgateway.model.AssociateGatewayToServerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.backupgateway.model.AssociateGatewayToServerResponse =
      zio.aws.backupgateway.model
        .AssociateGatewayToServerResponse(gatewayArn.map(value => value))
    def gatewayArn: Option[GatewayArn]
    def getGatewayArn: ZIO[Any, AwsError, GatewayArn] =
      AwsError.unwrapOptionField("gatewayArn", gatewayArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupgateway.model.AssociateGatewayToServerResponse
  ) extends zio.aws.backupgateway.model.AssociateGatewayToServerResponse.ReadOnly {
    override val gatewayArn: Option[GatewayArn] = scala
      .Option(impl.gatewayArn())
      .map(value => zio.aws.backupgateway.model.primitives.GatewayArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupgateway.model.AssociateGatewayToServerResponse
  ): zio.aws.backupgateway.model.AssociateGatewayToServerResponse.ReadOnly =
    new Wrapper(impl)
}
