package zio.aws.backupgateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.backupgateway.model.primitives.{VmwareTagName, VmwareCategory}
import scala.jdk.CollectionConverters._
final case class VmwareTag(
    vmwareCategory: Optional[VmwareCategory] = Optional.Absent,
    vmwareTagDescription: Optional[String] = Optional.Absent,
    vmwareTagName: Optional[VmwareTagName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupgateway.model.VmwareTag = {
    import VmwareTag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupgateway.model.VmwareTag
      .builder()
      .optionallyWith(
        vmwareCategory.map(value =>
          VmwareCategory.unwrap(value): java.lang.String
        )
      )(_.vmwareCategory)
      .optionallyWith(
        vmwareTagDescription.map(value => value: java.lang.String)
      )(_.vmwareTagDescription)
      .optionallyWith(
        vmwareTagName.map(value =>
          VmwareTagName.unwrap(value): java.lang.String
        )
      )(_.vmwareTagName)
      .build()
  }
  def asReadOnly: zio.aws.backupgateway.model.VmwareTag.ReadOnly =
    zio.aws.backupgateway.model.VmwareTag.wrap(buildAwsValue())
}
object VmwareTag {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupgateway.model.VmwareTag
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backupgateway.model.VmwareTag =
      zio.aws.backupgateway.model.VmwareTag(
        vmwareCategory.map(value => value),
        vmwareTagDescription.map(value => value),
        vmwareTagName.map(value => value)
      )
    def vmwareCategory: Optional[VmwareCategory]
    def vmwareTagDescription: Optional[String]
    def vmwareTagName: Optional[VmwareTagName]
    def getVmwareCategory: ZIO[Any, AwsError, VmwareCategory] =
      AwsError.unwrapOptionField("vmwareCategory", vmwareCategory)
    def getVmwareTagDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vmwareTagDescription", vmwareTagDescription)
    def getVmwareTagName: ZIO[Any, AwsError, VmwareTagName] =
      AwsError.unwrapOptionField("vmwareTagName", vmwareTagName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupgateway.model.VmwareTag
  ) extends zio.aws.backupgateway.model.VmwareTag.ReadOnly {
    override val vmwareCategory: Optional[VmwareCategory] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vmwareCategory())
        .map(value =>
          zio.aws.backupgateway.model.primitives.VmwareCategory(value)
        )
    override val vmwareTagDescription: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vmwareTagDescription())
      .map(value => value: String)
    override val vmwareTagName: Optional[VmwareTagName] = zio.aws.core.internal
      .optionalFromNullable(impl.vmwareTagName())
      .map(value => zio.aws.backupgateway.model.primitives.VmwareTagName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupgateway.model.VmwareTag
  ): zio.aws.backupgateway.model.VmwareTag.ReadOnly = new Wrapper(impl)
}
