package zio.aws.backupgateway.model
import zio.aws.backupgateway.model.primitives.{
  MinuteOfHour,
  HourOfDay,
  DayOfWeek,
  DayOfMonth
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class MaintenanceStartTime(
    dayOfMonth: Optional[DayOfMonth] = Optional.Absent,
    dayOfWeek: Optional[DayOfWeek] = Optional.Absent,
    hourOfDay: HourOfDay,
    minuteOfHour: MinuteOfHour
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupgateway.model.MaintenanceStartTime = {
    import MaintenanceStartTime.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupgateway.model.MaintenanceStartTime
      .builder()
      .optionallyWith(
        dayOfMonth.map(value => DayOfMonth.unwrap(value): Integer)
      )(_.dayOfMonth)
      .optionallyWith(dayOfWeek.map(value => DayOfWeek.unwrap(value): Integer))(
        _.dayOfWeek
      )
      .hourOfDay(HourOfDay.unwrap(hourOfDay): Integer)
      .minuteOfHour(MinuteOfHour.unwrap(minuteOfHour): Integer)
      .build()
  }
  def asReadOnly: zio.aws.backupgateway.model.MaintenanceStartTime.ReadOnly =
    zio.aws.backupgateway.model.MaintenanceStartTime.wrap(buildAwsValue())
}
object MaintenanceStartTime {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupgateway.model.MaintenanceStartTime
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backupgateway.model.MaintenanceStartTime =
      zio.aws.backupgateway.model.MaintenanceStartTime(
        dayOfMonth.map(value => value),
        dayOfWeek.map(value => value),
        hourOfDay,
        minuteOfHour
      )
    def dayOfMonth: Optional[DayOfMonth]
    def dayOfWeek: Optional[DayOfWeek]
    def hourOfDay: HourOfDay
    def minuteOfHour: MinuteOfHour
    def getDayOfMonth: ZIO[Any, AwsError, DayOfMonth] =
      AwsError.unwrapOptionField("dayOfMonth", dayOfMonth)
    def getDayOfWeek: ZIO[Any, AwsError, DayOfWeek] =
      AwsError.unwrapOptionField("dayOfWeek", dayOfWeek)
    def getHourOfDay: ZIO[Any, Nothing, HourOfDay] = ZIO.succeed(hourOfDay)
    def getMinuteOfHour: ZIO[Any, Nothing, MinuteOfHour] =
      ZIO.succeed(minuteOfHour)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupgateway.model.MaintenanceStartTime
  ) extends zio.aws.backupgateway.model.MaintenanceStartTime.ReadOnly {
    override val dayOfMonth: Optional[DayOfMonth] = zio.aws.core.internal
      .optionalFromNullable(impl.dayOfMonth())
      .map(value => zio.aws.backupgateway.model.primitives.DayOfMonth(value))
    override val dayOfWeek: Optional[DayOfWeek] = zio.aws.core.internal
      .optionalFromNullable(impl.dayOfWeek())
      .map(value => zio.aws.backupgateway.model.primitives.DayOfWeek(value))
    override val hourOfDay: HourOfDay =
      zio.aws.backupgateway.model.primitives.HourOfDay(impl.hourOfDay())
    override val minuteOfHour: MinuteOfHour =
      zio.aws.backupgateway.model.primitives.MinuteOfHour(impl.minuteOfHour())
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupgateway.model.MaintenanceStartTime
  ): zio.aws.backupgateway.model.MaintenanceStartTime.ReadOnly = new Wrapper(
    impl
  )
}
