package zio.aws.backupgateway.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.backupgateway.model.primitives.GatewayArn
import scala.jdk.CollectionConverters._
final case class GetGatewayRequest(gatewayArn: GatewayArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupgateway.model.GetGatewayRequest = {
    import GetGatewayRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupgateway.model.GetGatewayRequest
      .builder()
      .gatewayArn(GatewayArn.unwrap(gatewayArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.backupgateway.model.GetGatewayRequest.ReadOnly =
    zio.aws.backupgateway.model.GetGatewayRequest.wrap(buildAwsValue())
}
object GetGatewayRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupgateway.model.GetGatewayRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backupgateway.model.GetGatewayRequest =
      zio.aws.backupgateway.model.GetGatewayRequest(gatewayArn)
    def gatewayArn: GatewayArn
    def getGatewayArn: ZIO[Any, Nothing, GatewayArn] = ZIO.succeed(gatewayArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupgateway.model.GetGatewayRequest
  ) extends zio.aws.backupgateway.model.GetGatewayRequest.ReadOnly {
    override val gatewayArn: GatewayArn =
      zio.aws.backupgateway.model.primitives.GatewayArn(impl.gatewayArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupgateway.model.GetGatewayRequest
  ): zio.aws.backupgateway.model.GetGatewayRequest.ReadOnly = new Wrapper(impl)
}
