package zio.aws.backupgateway.model
import zio.aws.backupgateway.model.primitives.{
  Time,
  Host,
  ServerArn,
  LogGroupArn,
  KmsKeyArn,
  Name
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class HypervisorDetails(
    host: Optional[Host] = Optional.Absent,
    hypervisorArn: Optional[ServerArn] = Optional.Absent,
    kmsKeyArn: Optional[KmsKeyArn] = Optional.Absent,
    lastSuccessfulMetadataSyncTime: Optional[Time] = Optional.Absent,
    latestMetadataSyncStatus: Optional[
      zio.aws.backupgateway.model.SyncMetadataStatus
    ] = Optional.Absent,
    latestMetadataSyncStatusMessage: Optional[String] = Optional.Absent,
    logGroupArn: Optional[LogGroupArn] = Optional.Absent,
    name: Optional[Name] = Optional.Absent,
    state: Optional[zio.aws.backupgateway.model.HypervisorState] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupgateway.model.HypervisorDetails = {
    import HypervisorDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupgateway.model.HypervisorDetails
      .builder()
      .optionallyWith(host.map(value => Host.unwrap(value): java.lang.String))(
        _.host
      )
      .optionallyWith(
        hypervisorArn.map(value => ServerArn.unwrap(value): java.lang.String)
      )(_.hypervisorArn)
      .optionallyWith(
        kmsKeyArn.map(value => KmsKeyArn.unwrap(value): java.lang.String)
      )(_.kmsKeyArn)
      .optionallyWith(
        lastSuccessfulMetadataSyncTime.map(value => Time.unwrap(value): Instant)
      )(_.lastSuccessfulMetadataSyncTime)
      .optionallyWith(latestMetadataSyncStatus.map(value => value.unwrap))(
        _.latestMetadataSyncStatus
      )
      .optionallyWith(
        latestMetadataSyncStatusMessage.map(value => value: java.lang.String)
      )(_.latestMetadataSyncStatusMessage)
      .optionallyWith(
        logGroupArn.map(value => LogGroupArn.unwrap(value): java.lang.String)
      )(_.logGroupArn)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.backupgateway.model.HypervisorDetails.ReadOnly =
    zio.aws.backupgateway.model.HypervisorDetails.wrap(buildAwsValue())
}
object HypervisorDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupgateway.model.HypervisorDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backupgateway.model.HypervisorDetails =
      zio.aws.backupgateway.model.HypervisorDetails(
        host.map(value => value),
        hypervisorArn.map(value => value),
        kmsKeyArn.map(value => value),
        lastSuccessfulMetadataSyncTime.map(value => value),
        latestMetadataSyncStatus.map(value => value),
        latestMetadataSyncStatusMessage.map(value => value),
        logGroupArn.map(value => value),
        name.map(value => value),
        state.map(value => value)
      )
    def host: Optional[Host]
    def hypervisorArn: Optional[ServerArn]
    def kmsKeyArn: Optional[KmsKeyArn]
    def lastSuccessfulMetadataSyncTime: Optional[Time]
    def latestMetadataSyncStatus
        : Optional[zio.aws.backupgateway.model.SyncMetadataStatus]
    def latestMetadataSyncStatusMessage: Optional[String]
    def logGroupArn: Optional[LogGroupArn]
    def name: Optional[Name]
    def state: Optional[zio.aws.backupgateway.model.HypervisorState]
    def getHost: ZIO[Any, AwsError, Host] =
      AwsError.unwrapOptionField("host", host)
    def getHypervisorArn: ZIO[Any, AwsError, ServerArn] =
      AwsError.unwrapOptionField("hypervisorArn", hypervisorArn)
    def getKmsKeyArn: ZIO[Any, AwsError, KmsKeyArn] =
      AwsError.unwrapOptionField("kmsKeyArn", kmsKeyArn)
    def getLastSuccessfulMetadataSyncTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField(
        "lastSuccessfulMetadataSyncTime",
        lastSuccessfulMetadataSyncTime
      )
    def getLatestMetadataSyncStatus
        : ZIO[Any, AwsError, zio.aws.backupgateway.model.SyncMetadataStatus] =
      AwsError.unwrapOptionField(
        "latestMetadataSyncStatus",
        latestMetadataSyncStatus
      )
    def getLatestMetadataSyncStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "latestMetadataSyncStatusMessage",
        latestMetadataSyncStatusMessage
      )
    def getLogGroupArn: ZIO[Any, AwsError, LogGroupArn] =
      AwsError.unwrapOptionField("logGroupArn", logGroupArn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getState
        : ZIO[Any, AwsError, zio.aws.backupgateway.model.HypervisorState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupgateway.model.HypervisorDetails
  ) extends zio.aws.backupgateway.model.HypervisorDetails.ReadOnly {
    override val host: Optional[Host] = zio.aws.core.internal
      .optionalFromNullable(impl.host())
      .map(value => zio.aws.backupgateway.model.primitives.Host(value))
    override val hypervisorArn: Optional[ServerArn] = zio.aws.core.internal
      .optionalFromNullable(impl.hypervisorArn())
      .map(value => zio.aws.backupgateway.model.primitives.ServerArn(value))
    override val kmsKeyArn: Optional[KmsKeyArn] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyArn())
      .map(value => zio.aws.backupgateway.model.primitives.KmsKeyArn(value))
    override val lastSuccessfulMetadataSyncTime: Optional[Time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastSuccessfulMetadataSyncTime())
        .map(value => zio.aws.backupgateway.model.primitives.Time(value))
    override val latestMetadataSyncStatus
        : Optional[zio.aws.backupgateway.model.SyncMetadataStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestMetadataSyncStatus())
        .map(value =>
          zio.aws.backupgateway.model.SyncMetadataStatus.wrap(value)
        )
    override val latestMetadataSyncStatusMessage: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestMetadataSyncStatusMessage())
        .map(value => value: String)
    override val logGroupArn: Optional[LogGroupArn] = zio.aws.core.internal
      .optionalFromNullable(impl.logGroupArn())
      .map(value => zio.aws.backupgateway.model.primitives.LogGroupArn(value))
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.backupgateway.model.primitives.Name(value))
    override val state: Optional[zio.aws.backupgateway.model.HypervisorState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.backupgateway.model.HypervisorState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupgateway.model.HypervisorDetails
  ): zio.aws.backupgateway.model.HypervisorDetails.ReadOnly = new Wrapper(impl)
}
