package zio.aws.backupgateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.backupgateway.model.primitives.{IamRoleArn, ServerArn}
import scala.jdk.CollectionConverters._
final case class GetHypervisorPropertyMappingsResponse(
    hypervisorArn: Optional[ServerArn] = Optional.Absent,
    iamRoleArn: Optional[IamRoleArn] = Optional.Absent,
    vmwareToAwsTagMappings: Optional[
      Iterable[zio.aws.backupgateway.model.VmwareToAwsTagMapping]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupgateway.model.GetHypervisorPropertyMappingsResponse = {
    import GetHypervisorPropertyMappingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupgateway.model.GetHypervisorPropertyMappingsResponse
      .builder()
      .optionallyWith(
        hypervisorArn.map(value => ServerArn.unwrap(value): java.lang.String)
      )(_.hypervisorArn)
      .optionallyWith(
        iamRoleArn.map(value => IamRoleArn.unwrap(value): java.lang.String)
      )(_.iamRoleArn)
      .optionallyWith(
        vmwareToAwsTagMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vmwareToAwsTagMappings)
      .build()
  }
  def asReadOnly
      : zio.aws.backupgateway.model.GetHypervisorPropertyMappingsResponse.ReadOnly =
    zio.aws.backupgateway.model.GetHypervisorPropertyMappingsResponse
      .wrap(buildAwsValue())
}
object GetHypervisorPropertyMappingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupgateway.model.GetHypervisorPropertyMappingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.backupgateway.model.GetHypervisorPropertyMappingsResponse =
      zio.aws.backupgateway.model.GetHypervisorPropertyMappingsResponse(
        hypervisorArn.map(value => value),
        iamRoleArn.map(value => value),
        vmwareToAwsTagMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def hypervisorArn: Optional[ServerArn]
    def iamRoleArn: Optional[IamRoleArn]
    def vmwareToAwsTagMappings: Optional[
      List[zio.aws.backupgateway.model.VmwareToAwsTagMapping.ReadOnly]
    ]
    def getHypervisorArn: ZIO[Any, AwsError, ServerArn] =
      AwsError.unwrapOptionField("hypervisorArn", hypervisorArn)
    def getIamRoleArn: ZIO[Any, AwsError, IamRoleArn] =
      AwsError.unwrapOptionField("iamRoleArn", iamRoleArn)
    def getVmwareToAwsTagMappings: ZIO[Any, AwsError, List[
      zio.aws.backupgateway.model.VmwareToAwsTagMapping.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "vmwareToAwsTagMappings",
      vmwareToAwsTagMappings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupgateway.model.GetHypervisorPropertyMappingsResponse
  ) extends zio.aws.backupgateway.model.GetHypervisorPropertyMappingsResponse.ReadOnly {
    override val hypervisorArn: Optional[ServerArn] = zio.aws.core.internal
      .optionalFromNullable(impl.hypervisorArn())
      .map(value => zio.aws.backupgateway.model.primitives.ServerArn(value))
    override val iamRoleArn: Optional[IamRoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.iamRoleArn())
      .map(value => zio.aws.backupgateway.model.primitives.IamRoleArn(value))
    override val vmwareToAwsTagMappings: Optional[
      List[zio.aws.backupgateway.model.VmwareToAwsTagMapping.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.vmwareToAwsTagMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.backupgateway.model.VmwareToAwsTagMapping.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupgateway.model.GetHypervisorPropertyMappingsResponse
  ): zio.aws.backupgateway.model.GetHypervisorPropertyMappingsResponse.ReadOnly =
    new Wrapper(impl)
}
