package zio.aws.backupgateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.backupgateway.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListHypervisorsResponse(
    hypervisors: Optional[Iterable[zio.aws.backupgateway.model.Hypervisor]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupgateway.model.ListHypervisorsResponse = {
    import ListHypervisorsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupgateway.model.ListHypervisorsResponse
      .builder()
      .optionallyWith(
        hypervisors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.hypervisors)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.backupgateway.model.ListHypervisorsResponse.ReadOnly =
    zio.aws.backupgateway.model.ListHypervisorsResponse.wrap(buildAwsValue())
}
object ListHypervisorsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupgateway.model.ListHypervisorsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backupgateway.model.ListHypervisorsResponse =
      zio.aws.backupgateway.model.ListHypervisorsResponse(
        hypervisors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def hypervisors
        : Optional[List[zio.aws.backupgateway.model.Hypervisor.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getHypervisors: ZIO[Any, AwsError, List[
      zio.aws.backupgateway.model.Hypervisor.ReadOnly
    ]] = AwsError.unwrapOptionField("hypervisors", hypervisors)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupgateway.model.ListHypervisorsResponse
  ) extends zio.aws.backupgateway.model.ListHypervisorsResponse.ReadOnly {
    override val hypervisors
        : Optional[List[zio.aws.backupgateway.model.Hypervisor.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hypervisors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.backupgateway.model.Hypervisor.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.backupgateway.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupgateway.model.ListHypervisorsResponse
  ): zio.aws.backupgateway.model.ListHypervisorsResponse.ReadOnly = new Wrapper(
    impl
  )
}
