package zio.aws.backupgateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.backupgateway.model.primitives.ServerArn
import scala.jdk.CollectionConverters._
final case class PutHypervisorPropertyMappingsResponse(
    hypervisorArn: Optional[ServerArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupgateway.model.PutHypervisorPropertyMappingsResponse = {
    import PutHypervisorPropertyMappingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupgateway.model.PutHypervisorPropertyMappingsResponse
      .builder()
      .optionallyWith(
        hypervisorArn.map(value => ServerArn.unwrap(value): java.lang.String)
      )(_.hypervisorArn)
      .build()
  }
  def asReadOnly
      : zio.aws.backupgateway.model.PutHypervisorPropertyMappingsResponse.ReadOnly =
    zio.aws.backupgateway.model.PutHypervisorPropertyMappingsResponse
      .wrap(buildAwsValue())
}
object PutHypervisorPropertyMappingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupgateway.model.PutHypervisorPropertyMappingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.backupgateway.model.PutHypervisorPropertyMappingsResponse =
      zio.aws.backupgateway.model.PutHypervisorPropertyMappingsResponse(
        hypervisorArn.map(value => value)
      )
    def hypervisorArn: Optional[ServerArn]
    def getHypervisorArn: ZIO[Any, AwsError, ServerArn] =
      AwsError.unwrapOptionField("hypervisorArn", hypervisorArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupgateway.model.PutHypervisorPropertyMappingsResponse
  ) extends zio.aws.backupgateway.model.PutHypervisorPropertyMappingsResponse.ReadOnly {
    override val hypervisorArn: Optional[ServerArn] = zio.aws.core.internal
      .optionalFromNullable(impl.hypervisorArn())
      .map(value => zio.aws.backupgateway.model.primitives.ServerArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupgateway.model.PutHypervisorPropertyMappingsResponse
  ): zio.aws.backupgateway.model.PutHypervisorPropertyMappingsResponse.ReadOnly =
    new Wrapper(impl)
}
