package zio.aws.backupgateway.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.backupgateway.model.primitives.GatewayArn
import scala.jdk.CollectionConverters._
final case class DeleteGatewayRequest(gatewayArn: GatewayArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupgateway.model.DeleteGatewayRequest = {
    import DeleteGatewayRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupgateway.model.DeleteGatewayRequest
      .builder()
      .gatewayArn(GatewayArn.unwrap(gatewayArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.backupgateway.model.DeleteGatewayRequest.ReadOnly =
    zio.aws.backupgateway.model.DeleteGatewayRequest.wrap(buildAwsValue())
}
object DeleteGatewayRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupgateway.model.DeleteGatewayRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backupgateway.model.DeleteGatewayRequest =
      zio.aws.backupgateway.model.DeleteGatewayRequest(gatewayArn)
    def gatewayArn: GatewayArn
    def getGatewayArn: ZIO[Any, Nothing, GatewayArn] = ZIO.succeed(gatewayArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupgateway.model.DeleteGatewayRequest
  ) extends zio.aws.backupgateway.model.DeleteGatewayRequest.ReadOnly {
    override val gatewayArn: GatewayArn =
      zio.aws.backupgateway.model.primitives.GatewayArn(impl.gatewayArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupgateway.model.DeleteGatewayRequest
  ): zio.aws.backupgateway.model.DeleteGatewayRequest.ReadOnly = new Wrapper(
    impl
  )
}
