package zio.aws.backupgateway.model
import zio.aws.backupgateway.model.primitives.{ResourceArn, Path, Time, Name}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class VirtualMachineDetails(
    hostName: Optional[Name] = Optional.Absent,
    hypervisorId: Optional[String] = Optional.Absent,
    lastBackupDate: Optional[Time] = Optional.Absent,
    name: Optional[Name] = Optional.Absent,
    path: Optional[Path] = Optional.Absent,
    resourceArn: Optional[ResourceArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupgateway.model.VirtualMachineDetails = {
    import VirtualMachineDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupgateway.model.VirtualMachineDetails
      .builder()
      .optionallyWith(
        hostName.map(value => Name.unwrap(value): java.lang.String)
      )(_.hostName)
      .optionallyWith(hypervisorId.map(value => value: java.lang.String))(
        _.hypervisorId
      )
      .optionallyWith(lastBackupDate.map(value => Time.unwrap(value): Instant))(
        _.lastBackupDate
      )
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(path.map(value => Path.unwrap(value): java.lang.String))(
        _.path
      )
      .optionallyWith(
        resourceArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .build()
  }
  def asReadOnly: zio.aws.backupgateway.model.VirtualMachineDetails.ReadOnly =
    zio.aws.backupgateway.model.VirtualMachineDetails.wrap(buildAwsValue())
}
object VirtualMachineDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupgateway.model.VirtualMachineDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backupgateway.model.VirtualMachineDetails =
      zio.aws.backupgateway.model.VirtualMachineDetails(
        hostName.map(value => value),
        hypervisorId.map(value => value),
        lastBackupDate.map(value => value),
        name.map(value => value),
        path.map(value => value),
        resourceArn.map(value => value)
      )
    def hostName: Optional[Name]
    def hypervisorId: Optional[String]
    def lastBackupDate: Optional[Time]
    def name: Optional[Name]
    def path: Optional[Path]
    def resourceArn: Optional[ResourceArn]
    def getHostName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("hostName", hostName)
    def getHypervisorId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hypervisorId", hypervisorId)
    def getLastBackupDate: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("lastBackupDate", lastBackupDate)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getPath: ZIO[Any, AwsError, Path] =
      AwsError.unwrapOptionField("path", path)
    def getResourceArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupgateway.model.VirtualMachineDetails
  ) extends zio.aws.backupgateway.model.VirtualMachineDetails.ReadOnly {
    override val hostName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.hostName())
      .map(value => zio.aws.backupgateway.model.primitives.Name(value))
    override val hypervisorId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.hypervisorId())
      .map(value => value: String)
    override val lastBackupDate: Optional[Time] = zio.aws.core.internal
      .optionalFromNullable(impl.lastBackupDate())
      .map(value => zio.aws.backupgateway.model.primitives.Time(value))
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.backupgateway.model.primitives.Name(value))
    override val path: Optional[Path] = zio.aws.core.internal
      .optionalFromNullable(impl.path())
      .map(value => zio.aws.backupgateway.model.primitives.Path(value))
    override val resourceArn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceArn())
      .map(value => zio.aws.backupgateway.model.primitives.ResourceArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupgateway.model.VirtualMachineDetails
  ): zio.aws.backupgateway.model.VirtualMachineDetails.ReadOnly = new Wrapper(
    impl
  )
}
