package zio.aws.backupgateway.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.backupgateway.model.primitives.{ServerArn, GatewayArn}
import scala.jdk.CollectionConverters._
final case class AssociateGatewayToServerRequest(
    gatewayArn: GatewayArn,
    serverArn: ServerArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupgateway.model.AssociateGatewayToServerRequest = {
    import AssociateGatewayToServerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupgateway.model.AssociateGatewayToServerRequest
      .builder()
      .gatewayArn(GatewayArn.unwrap(gatewayArn): java.lang.String)
      .serverArn(ServerArn.unwrap(serverArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.backupgateway.model.AssociateGatewayToServerRequest.ReadOnly =
    zio.aws.backupgateway.model.AssociateGatewayToServerRequest
      .wrap(buildAwsValue())
}
object AssociateGatewayToServerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupgateway.model.AssociateGatewayToServerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.backupgateway.model.AssociateGatewayToServerRequest =
      zio.aws.backupgateway.model
        .AssociateGatewayToServerRequest(gatewayArn, serverArn)
    def gatewayArn: GatewayArn
    def serverArn: ServerArn
    def getGatewayArn: ZIO[Any, Nothing, GatewayArn] = ZIO.succeed(gatewayArn)
    def getServerArn: ZIO[Any, Nothing, ServerArn] = ZIO.succeed(serverArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupgateway.model.AssociateGatewayToServerRequest
  ) extends zio.aws.backupgateway.model.AssociateGatewayToServerRequest.ReadOnly {
    override val gatewayArn: GatewayArn =
      zio.aws.backupgateway.model.primitives.GatewayArn(impl.gatewayArn())
    override val serverArn: ServerArn =
      zio.aws.backupgateway.model.primitives.ServerArn(impl.serverArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupgateway.model.AssociateGatewayToServerRequest
  ): zio.aws.backupgateway.model.AssociateGatewayToServerRequest.ReadOnly =
    new Wrapper(impl)
}
