package zio.aws.backupgateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.backupgateway.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListVirtualMachinesResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    virtualMachines: Optional[
      Iterable[zio.aws.backupgateway.model.VirtualMachine]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupgateway.model.ListVirtualMachinesResponse = {
    import ListVirtualMachinesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupgateway.model.ListVirtualMachinesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        virtualMachines.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.virtualMachines)
      .build()
  }
  def asReadOnly
      : zio.aws.backupgateway.model.ListVirtualMachinesResponse.ReadOnly =
    zio.aws.backupgateway.model.ListVirtualMachinesResponse
      .wrap(buildAwsValue())
}
object ListVirtualMachinesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupgateway.model.ListVirtualMachinesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backupgateway.model.ListVirtualMachinesResponse =
      zio.aws.backupgateway.model.ListVirtualMachinesResponse(
        nextToken.map(value => value),
        virtualMachines.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def virtualMachines
        : Optional[List[zio.aws.backupgateway.model.VirtualMachine.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getVirtualMachines: ZIO[Any, AwsError, List[
      zio.aws.backupgateway.model.VirtualMachine.ReadOnly
    ]] = AwsError.unwrapOptionField("virtualMachines", virtualMachines)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupgateway.model.ListVirtualMachinesResponse
  ) extends zio.aws.backupgateway.model.ListVirtualMachinesResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.backupgateway.model.primitives.NextToken(value))
    override val virtualMachines
        : Optional[List[zio.aws.backupgateway.model.VirtualMachine.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.virtualMachines())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.backupgateway.model.VirtualMachine.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupgateway.model.ListVirtualMachinesResponse
  ): zio.aws.backupgateway.model.ListVirtualMachinesResponse.ReadOnly =
    new Wrapper(impl)
}
