package zio.aws.backupgateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.backupgateway.model.primitives.GatewayArn
import scala.jdk.CollectionConverters._
final case class PutMaintenanceStartTimeResponse(
    gatewayArn: Optional[GatewayArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupgateway.model.PutMaintenanceStartTimeResponse = {
    import PutMaintenanceStartTimeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupgateway.model.PutMaintenanceStartTimeResponse
      .builder()
      .optionallyWith(
        gatewayArn.map(value => GatewayArn.unwrap(value): java.lang.String)
      )(_.gatewayArn)
      .build()
  }
  def asReadOnly
      : zio.aws.backupgateway.model.PutMaintenanceStartTimeResponse.ReadOnly =
    zio.aws.backupgateway.model.PutMaintenanceStartTimeResponse
      .wrap(buildAwsValue())
}
object PutMaintenanceStartTimeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupgateway.model.PutMaintenanceStartTimeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.backupgateway.model.PutMaintenanceStartTimeResponse =
      zio.aws.backupgateway.model
        .PutMaintenanceStartTimeResponse(gatewayArn.map(value => value))
    def gatewayArn: Optional[GatewayArn]
    def getGatewayArn: ZIO[Any, AwsError, GatewayArn] =
      AwsError.unwrapOptionField("gatewayArn", gatewayArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupgateway.model.PutMaintenanceStartTimeResponse
  ) extends zio.aws.backupgateway.model.PutMaintenanceStartTimeResponse.ReadOnly {
    override val gatewayArn: Optional[GatewayArn] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayArn())
      .map(value => zio.aws.backupgateway.model.primitives.GatewayArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupgateway.model.PutMaintenanceStartTimeResponse
  ): zio.aws.backupgateway.model.PutMaintenanceStartTimeResponse.ReadOnly =
    new Wrapper(impl)
}
