package zio.aws.backupgateway.model
import zio.aws.backupgateway.model.primitives.{
  Time,
  HypervisorId,
  Name,
  GatewayArn
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Gateway(
    gatewayArn: Optional[GatewayArn] = Optional.Absent,
    gatewayDisplayName: Optional[Name] = Optional.Absent,
    gatewayType: Optional[zio.aws.backupgateway.model.GatewayType] =
      Optional.Absent,
    hypervisorId: Optional[HypervisorId] = Optional.Absent,
    lastSeenTime: Optional[Time] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupgateway.model.Gateway = {
    import Gateway.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupgateway.model.Gateway
      .builder()
      .optionallyWith(
        gatewayArn.map(value => GatewayArn.unwrap(value): java.lang.String)
      )(_.gatewayArn)
      .optionallyWith(
        gatewayDisplayName.map(value => Name.unwrap(value): java.lang.String)
      )(_.gatewayDisplayName)
      .optionallyWith(gatewayType.map(value => value.unwrap))(_.gatewayType)
      .optionallyWith(
        hypervisorId.map(value => HypervisorId.unwrap(value): java.lang.String)
      )(_.hypervisorId)
      .optionallyWith(lastSeenTime.map(value => Time.unwrap(value): Instant))(
        _.lastSeenTime
      )
      .build()
  }
  def asReadOnly: zio.aws.backupgateway.model.Gateway.ReadOnly =
    zio.aws.backupgateway.model.Gateway.wrap(buildAwsValue())
}
object Gateway {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupgateway.model.Gateway
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backupgateway.model.Gateway =
      zio.aws.backupgateway.model.Gateway(
        gatewayArn.map(value => value),
        gatewayDisplayName.map(value => value),
        gatewayType.map(value => value),
        hypervisorId.map(value => value),
        lastSeenTime.map(value => value)
      )
    def gatewayArn: Optional[GatewayArn]
    def gatewayDisplayName: Optional[Name]
    def gatewayType: Optional[zio.aws.backupgateway.model.GatewayType]
    def hypervisorId: Optional[HypervisorId]
    def lastSeenTime: Optional[Time]
    def getGatewayArn: ZIO[Any, AwsError, GatewayArn] =
      AwsError.unwrapOptionField("gatewayArn", gatewayArn)
    def getGatewayDisplayName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("gatewayDisplayName", gatewayDisplayName)
    def getGatewayType
        : ZIO[Any, AwsError, zio.aws.backupgateway.model.GatewayType] =
      AwsError.unwrapOptionField("gatewayType", gatewayType)
    def getHypervisorId: ZIO[Any, AwsError, HypervisorId] =
      AwsError.unwrapOptionField("hypervisorId", hypervisorId)
    def getLastSeenTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("lastSeenTime", lastSeenTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupgateway.model.Gateway
  ) extends zio.aws.backupgateway.model.Gateway.ReadOnly {
    override val gatewayArn: Optional[GatewayArn] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayArn())
      .map(value => zio.aws.backupgateway.model.primitives.GatewayArn(value))
    override val gatewayDisplayName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayDisplayName())
      .map(value => zio.aws.backupgateway.model.primitives.Name(value))
    override val gatewayType
        : Optional[zio.aws.backupgateway.model.GatewayType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gatewayType())
        .map(value => zio.aws.backupgateway.model.GatewayType.wrap(value))
    override val hypervisorId: Optional[HypervisorId] = zio.aws.core.internal
      .optionalFromNullable(impl.hypervisorId())
      .map(value => zio.aws.backupgateway.model.primitives.HypervisorId(value))
    override val lastSeenTime: Optional[Time] = zio.aws.core.internal
      .optionalFromNullable(impl.lastSeenTime())
      .map(value => zio.aws.backupgateway.model.primitives.Time(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupgateway.model.Gateway
  ): zio.aws.backupgateway.model.Gateway.ReadOnly = new Wrapper(impl)
}
