package zio.aws.backupgateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.backupgateway.model.primitives.ServerArn
import scala.jdk.CollectionConverters._
final case class UpdateHypervisorResponse(
    hypervisorArn: Optional[ServerArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupgateway.model.UpdateHypervisorResponse = {
    import UpdateHypervisorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupgateway.model.UpdateHypervisorResponse
      .builder()
      .optionallyWith(
        hypervisorArn.map(value => ServerArn.unwrap(value): java.lang.String)
      )(_.hypervisorArn)
      .build()
  }
  def asReadOnly
      : zio.aws.backupgateway.model.UpdateHypervisorResponse.ReadOnly =
    zio.aws.backupgateway.model.UpdateHypervisorResponse.wrap(buildAwsValue())
}
object UpdateHypervisorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupgateway.model.UpdateHypervisorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backupgateway.model.UpdateHypervisorResponse =
      zio.aws.backupgateway.model
        .UpdateHypervisorResponse(hypervisorArn.map(value => value))
    def hypervisorArn: Optional[ServerArn]
    def getHypervisorArn: ZIO[Any, AwsError, ServerArn] =
      AwsError.unwrapOptionField("hypervisorArn", hypervisorArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupgateway.model.UpdateHypervisorResponse
  ) extends zio.aws.backupgateway.model.UpdateHypervisorResponse.ReadOnly {
    override val hypervisorArn: Optional[ServerArn] = zio.aws.core.internal
      .optionalFromNullable(impl.hypervisorArn())
      .map(value => zio.aws.backupgateway.model.primitives.ServerArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupgateway.model.UpdateHypervisorResponse
  ): zio.aws.backupgateway.model.UpdateHypervisorResponse.ReadOnly =
    new Wrapper(impl)
}
