package zio.aws.backupgateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.backupgateway.model.primitives.{
  Username,
  Password,
  Host,
  GatewayArn
}
import scala.jdk.CollectionConverters._
final case class TestHypervisorConfigurationRequest(
    gatewayArn: GatewayArn,
    host: Host,
    password: Optional[Password] = Optional.Absent,
    username: Optional[Username] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupgateway.model.TestHypervisorConfigurationRequest = {
    import TestHypervisorConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupgateway.model.TestHypervisorConfigurationRequest
      .builder()
      .gatewayArn(GatewayArn.unwrap(gatewayArn): java.lang.String)
      .host(Host.unwrap(host): java.lang.String)
      .optionallyWith(
        password.map(value => Password.unwrap(value): java.lang.String)
      )(_.password)
      .optionallyWith(
        username.map(value => Username.unwrap(value): java.lang.String)
      )(_.username)
      .build()
  }
  def asReadOnly
      : zio.aws.backupgateway.model.TestHypervisorConfigurationRequest.ReadOnly =
    zio.aws.backupgateway.model.TestHypervisorConfigurationRequest
      .wrap(buildAwsValue())
}
object TestHypervisorConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupgateway.model.TestHypervisorConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.backupgateway.model.TestHypervisorConfigurationRequest =
      zio.aws.backupgateway.model.TestHypervisorConfigurationRequest(
        gatewayArn,
        host,
        password.map(value => value),
        username.map(value => value)
      )
    def gatewayArn: GatewayArn
    def host: Host
    def password: Optional[Password]
    def username: Optional[Username]
    def getGatewayArn: ZIO[Any, Nothing, GatewayArn] = ZIO.succeed(gatewayArn)
    def getHost: ZIO[Any, Nothing, Host] = ZIO.succeed(host)
    def getPassword: ZIO[Any, AwsError, Password] =
      AwsError.unwrapOptionField("password", password)
    def getUsername: ZIO[Any, AwsError, Username] =
      AwsError.unwrapOptionField("username", username)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupgateway.model.TestHypervisorConfigurationRequest
  ) extends zio.aws.backupgateway.model.TestHypervisorConfigurationRequest.ReadOnly {
    override val gatewayArn: GatewayArn =
      zio.aws.backupgateway.model.primitives.GatewayArn(impl.gatewayArn())
    override val host: Host =
      zio.aws.backupgateway.model.primitives.Host(impl.host())
    override val password: Optional[Password] = zio.aws.core.internal
      .optionalFromNullable(impl.password())
      .map(value => zio.aws.backupgateway.model.primitives.Password(value))
    override val username: Optional[Username] = zio.aws.core.internal
      .optionalFromNullable(impl.username())
      .map(value => zio.aws.backupgateway.model.primitives.Username(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupgateway.model.TestHypervisorConfigurationRequest
  ): zio.aws.backupgateway.model.TestHypervisorConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
