package zio.aws.backupgateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backupgateway.model.primitives.ServerArn
import scala.jdk.CollectionConverters._
final case class ImportHypervisorConfigurationResponse(
    hypervisorArn: Option[ServerArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupgateway.model.ImportHypervisorConfigurationResponse = {
    import ImportHypervisorConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupgateway.model.ImportHypervisorConfigurationResponse
      .builder()
      .optionallyWith(
        hypervisorArn.map(value => ServerArn.unwrap(value): java.lang.String)
      )(_.hypervisorArn)
      .build()
  }
  def asReadOnly
      : zio.aws.backupgateway.model.ImportHypervisorConfigurationResponse.ReadOnly =
    zio.aws.backupgateway.model.ImportHypervisorConfigurationResponse
      .wrap(buildAwsValue())
}
object ImportHypervisorConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupgateway.model.ImportHypervisorConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.backupgateway.model.ImportHypervisorConfigurationResponse =
      zio.aws.backupgateway.model.ImportHypervisorConfigurationResponse(
        hypervisorArn.map(value => value)
      )
    def hypervisorArn: Option[ServerArn]
    def getHypervisorArn: ZIO[Any, AwsError, ServerArn] =
      AwsError.unwrapOptionField("hypervisorArn", hypervisorArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupgateway.model.ImportHypervisorConfigurationResponse
  ) extends zio.aws.backupgateway.model.ImportHypervisorConfigurationResponse.ReadOnly {
    override val hypervisorArn: Option[ServerArn] = scala
      .Option(impl.hypervisorArn())
      .map(value => zio.aws.backupgateway.model.primitives.ServerArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupgateway.model.ImportHypervisorConfigurationResponse
  ): zio.aws.backupgateway.model.ImportHypervisorConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
