package zio.aws.backupgateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backupgateway.model.primitives.ServerArn
import scala.jdk.CollectionConverters._
final case class DeleteHypervisorResponse(
    hypervisorArn: Option[ServerArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupgateway.model.DeleteHypervisorResponse = {
    import DeleteHypervisorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupgateway.model.DeleteHypervisorResponse
      .builder()
      .optionallyWith(
        hypervisorArn.map(value => ServerArn.unwrap(value): java.lang.String)
      )(_.hypervisorArn)
      .build()
  }
  def asReadOnly
      : zio.aws.backupgateway.model.DeleteHypervisorResponse.ReadOnly =
    zio.aws.backupgateway.model.DeleteHypervisorResponse.wrap(buildAwsValue())
}
object DeleteHypervisorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupgateway.model.DeleteHypervisorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backupgateway.model.DeleteHypervisorResponse =
      zio.aws.backupgateway.model
        .DeleteHypervisorResponse(hypervisorArn.map(value => value))
    def hypervisorArn: Option[ServerArn]
    def getHypervisorArn: ZIO[Any, AwsError, ServerArn] =
      AwsError.unwrapOptionField("hypervisorArn", hypervisorArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupgateway.model.DeleteHypervisorResponse
  ) extends zio.aws.backupgateway.model.DeleteHypervisorResponse.ReadOnly {
    override val hypervisorArn: Option[ServerArn] = scala
      .Option(impl.hypervisorArn())
      .map(value => zio.aws.backupgateway.model.primitives.ServerArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupgateway.model.DeleteHypervisorResponse
  ): zio.aws.backupgateway.model.DeleteHypervisorResponse.ReadOnly =
    new Wrapper(impl)
}
